// src/utils/api.ts
const BASE = "https://api.air1bet.com";

export async function apiFetch<T = any>(
  path: string,
  options: RequestInit = {}
): Promise<T> {
  const token = localStorage.getItem("token");

  const isLoginPath = path === "/api/staff/auth/login";

  const headers: Record<string, string> = {
    "Content-Type": "application/json",
    ...(options.headers as any),
    ...(token && !isLoginPath ? { Authorization: `Bearer ${token}` } : {})
  };

  const res = await fetch(`${BASE}${path}`, {
    ...options,
    headers
  });

  if (res.status === 401) {
    const errorData = await res.json().catch(() => ({}));
    if (errorData.code === 'TOKEN_EXPIRED') {
      console.log('Session expired, redirecting to login...');
    }
    localStorage.clear();
    window.location.href = "/login";
    throw new Error("Unauthorized");
  }

  if (!res.ok) {
    const text = await res.text();
    throw new Error(text || `Error ${res.status}`);
  }

  return (res.status === 204 ? ({} as T) : (await res.json())) as T;
}
