const express = require('express');
const router = express.Router();
const multer = require('multer');
const upload = multer();
const {
    getPaymentDetails,
    addPaymentDetail,
    updatePaymentDetail,
    deletePaymentDetail
} = require('./bankcontroller');
const currencyCheckMiddleware = require('./middelware');

router.get('/:coin_type', 
    currencyCheckMiddleware,
    getPaymentDetails
);

router.post('/:coin_type',
    currencyCheckMiddleware,
    upload.single('qr_image'),
    addPaymentDetail
);

router.put('/:coin_type/:id',
    currencyCheckMiddleware,
    upload.single('qr_image'),
    updatePaymentDetail
);

router.delete('/:coin_type/:id',
    currencyCheckMiddleware,
    deletePaymentDetail
);



module.exports = router;

