const pg = require('../General/Model');

const currencyCheckMiddleware = async (req, res, next) => {
    try {
        const { coin_type } = req.params;
        // Only select the specific currency column we need to check
        const query = `SELECT ${coin_type.toLowerCase()} FROM siteconfig WHERE ${coin_type.toLowerCase()} = true`;
        const result = await pg.query(query);
        
        if (result.rows.length === 0) {
            return res.status(403).json({
                error: 'Currency not enabled in site configuration'
            });
        }
        next();
    } catch (error) {
        console.error('Currency check error:', error);
        res.status(500).json({ error: 'Invalid currency type or configuration error' });
    }
};

module.exports = currencyCheckMiddleware;