const _ = require('lodash');
const Model = require('../General/Model');
const H = require('../General/Helper');
const config = require('../config');
const UserRule = require('../Users/Rule');
var NodeCache = require('../General/Dummy')


var developer = config.developer;

if (!developer) {
    NodeCache = require("node-cache");
}

const myCache = new NodeCache();

const Agent = {};

/*
 * Check The BankRoll and Bet Amount
 * TODO
 */
Agent.getBank = function (game, bet, coin, client, callback) {
    return callback(true);

    //If is Bot
    if (client === null) return callback(true);

    if (!game && !bet && !coin) return;

    coin = _.lowerCase(coin);

    if (coin === 'nc') {
        return callback(true);
    }

    bet = _.toNumber(bet);

    let cache = myCache.get('bankroll_' + game);

    if (!_.isUndefined(cache)) {
        let bank = _.toNumber(cache);

        if (_.isNaN(bank)) {
            return callback(true);
        }

        //Players Can Make Profit Only 0.0010% From BankRoll
        bank = bank / 5;

        if (bet >= bank) {
            return callback(false);
        }

        callback(true);
    }
    else {
        Model.query('SELECT balance FROM bankroll WHERE game = $1', [game], function (err, result) {
            if (err) {
                console.log('ERROR on Agent : 21', err);
                return callback(false);
            }

            if (result.rows.length === 0) return;

            let bc = result.rows[0].balance[coin];

            myCache.mset([
                { key: 'bankroll_' + game, val: bc, ttl: 180 }
            ])

            if (_.isUndefined(bc))
                bc = '0.00000000';

            let bank = _.toNumber(bc);

            if (_.isNaN(bank)) {
                return callback(true);
            }

            if (developer) return callback(true)

            //Players Can Make Profit Only 0.0010% From BankRoll
            bank = bank / 5;

            if (bet >= bank) {
                return callback(false);
            }

            callback(true);
        });
    }
}

/*
 * Check User Can Make Profit
*/
Agent.canProfit = function (id, coin, callback) {
    id = _.toNumber(id)
    coin = _.lowerCase(coin)
    UserRule.checkMaxProfit(id, (status) => {
        callback(status)
    })
}


module.exports = Agent;