const _ = require('lodash');
const assert = require('assert');
const CryptoJS = require("crypto-js");
const SHA256 = require("crypto-js/sha256");
const UserRule = require('../Users/Rule');
const { encode } = require('../General/Buffer');
const H = require('../General/Helper');
const C = require('../General/Constant');
const Hash = require('./Hash');

//Declare Bots Object
const Bots = {};

/*
 * Simple random integer
 */
function random(length) {
    return Math.floor(Math.random() * length);
}

/*
 * Generate Random Data
 */
function generateData(coin) {
    let amount = H.getRandomInt(2000) / 100000000;

    if (coin === 'doge')
        amount = H.getRandomInt(10000000000) / 100000000;

    if (coin === 'trx')
        amount = H.getRandomInt(1000000000) / 10000000;

    if (coin === 'usdt' && coin === 'usdp' && coin === 'usdc' && coin === 'tusd' && coin === 'busd')
        amount = H.getRandomInt(1000000000) / 100000000;

    let command = 'play';

    let wins = [true, false];
    let win = wins[H.getRandomInt(wins.length)];

    let risks = [3, 2];
    let risk = wins[H.getRandomInt(risks.length)];
    let bot = true;

    return {
        bot,
        coin,
        amount,
        command,
        win,
        risk
    }
}

/*
 * Hilo
 */
function hilo() {
    var selected = ['high', 'low'];

    var arr = [];
    for (var i = 0; i < H.getRandomBetween(1, 6); i++)
        arr.push(H.getRandomBetween(1, 52));

    return {
        selected: selected[H.getRandomInt(selected.length)],
        cards: arr
    }
}

/*
 * Video Poker
 */
function videopoker() {
    let hold = [true, false];

    let card = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 'Q', 'K', 'J', 'A'];

    var arr = [];
    for (var i = 0; i < 5; i++) {
        var obj = {
            // card: card[H.getRandomInt(card.length)],
            card: card[H.getRandomInt(5)],
            hold: hold[H.getRandomInt(hold.length)]
        }
        arr.push(obj)
    }

    arr.length = 5;

    return arr;
}

/*
 * BlackJack
 */
function blackjack() {
    let hold = [true, false];

    let card = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 'Q', 'K', 'J', 'A'];

    var arr = [];
    for (var i = 0; i < H.getRandomBetween(2, 5); i++) {
        var obj = {
            rank: card[H.getRandomInt(card.length)],
            value: card[H.getRandomInt(card.length)]
        }

        arr.push(obj)
    }

    return arr
}

/*
 * Roulette
 */
function roulette(hash) {
    hash = hash.substring(0, 10);
    var result = parseInt(hash, 16);
    result = result % 10;
    result = Math.min(result, 36);
    return result;
}

/*
 * HashDice Roll
 */
function hashdice(seed) {
    let hash = SHA256(seed).toString();
    let h = parseInt(hash.slice(0, 13), 16);
    let e = Math.pow(2, 52);
    let result = Math.floor((98 * e) / (e - h));
    result = (result / 100).toFixed(2);
    result = result * 8880;
    result = result.toFixed(0);
    return parseFloat(result);
}

/*
 * Generate Mine Result
 */
function mine(hash) {
    var arr = [];
    var rand = [3, 5, 10, 24];
    var randIndex = Math.floor(Math.random() * rand.length)
    var mines = rand[randIndex];
    while (arr.length < mines) {
        var r = H.getRandomBetween(1, 25)
        if (arr.indexOf(r) === -1) arr.push(r);
    }
    return arr;
}

/*
 * Generate Keno Result
 */
function keno(hash) {
    const salt = 'salt waiting to be generated';
    const allNums = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40
    ];
    const hmac = CryptoJS.HmacSHA256(CryptoJS.enc.Hex.parse(hash), salt);
    const seed = hmac.toString(CryptoJS.enc.Hex);
    let finalNums = createNums(allNums, seed);
    finalNums = createNums(finalNums, seed);
    return finalNums.slice(0, 10).map(m => m.num)
}

/*
 * Create Keno Numbers
 */
function createNums(allNums, hash) {
    const nums = [];
    let h = CryptoJS.SHA256(hash).toString(CryptoJS.enc.Hex);
    allNums.forEach((c) => {
        nums.push({
            num: c,
            hash: h
        });
        h = h.substring(1) + h.charAt(0);
    });
    nums.sort(function (o1, o2) {
        if (o1.hash < o2.hash) {
            return -1;
        } else if (o1.hash === o2.hash) {
            return 0;
        } else {
            return 1;
        }
    });
    return nums;
}

/*
 * Generate Diamond Result
 */
function diamond() {
    let r = [1, 2, 3, 4, 5];

    let randomNumbers = [];
    for (var i = 0; i < 5; i++) {
        randomNumbers.push(r[random(r.length)])
    }
    return randomNumbers;
}

/**
 * Play Bots
 */
function Play(io) {
    setInterval(function () {
        UserRule.getRandomBots((bots) => {
            if (!bots) return;
            if (_.isUndefined(bots)) return;
            if (bots.length === 0) return;
            bots.forEach((bot, i) => {
                Start(io, bot, bot.game);
            })
        })
    }, 20000);
}

/*
 * Start Playing 
 */
function Start(io, bot, game) {
    if (_.isUndefined(bot)) return;
    let coin = bot.coin ? bot.coin : 'btc';

    //Add Delay for natural
    H.wait(H.getRandomBetween(2000, 4000)).then(() => {
        //Init Bot Play
        Init(io, parseFloat(bot.id), generateData(_.lowerCase(coin)), game);
    })
}

/*
 * Intialize Game By Bot
 */
function Init(io, id, data, game) {
    //Make A New Bet Record
    UserRule.makeBetBeforePlay(data, id, game, (gid, error) => {
        if (!error) {
            if (!gid) return;

            //End Game
            H.wait(H.getRandomBetween(1000, 3000)).then(() => {
                let rands = [0.00000000, parseFloat(data.amount) / 3];
                let profit = rands[H.getRandomInt(rands.length)];

                let randomResult = Hash.make();
                let hash = randomResult.hash;
                let result = randomResult.result;

                if (game === 'hash_dice') {
                    result = hashdice(hash);
                } else
                    if (game === 'singlekeno') {
                        result = keno(hash);
                    } else
                        if (game === 'roulette') {
                            result = roulette(hash);
                        } else
                            if (game === 'mine') {
                                result = mine(hash);
                            } else
                                if (game === 'hilo') {
                                    result = hilo();
                                } else
                                    if (game === 'videopoker') {
                                        let initialHand = videopoker();
                                        let finalHand = videopoker();
                                        result = { initialHand, finalHand }
                                    }
                                    else
                                        if (game === 'blackjack') {
                                            let pCards = blackjack();
                                            let dCards = blackjack();
                                            result = { pCards, dCards }
                                        }
                                        else
                                            if (game === 'diamond') {
                                                result = diamond();
                                                let isWinner = false;
                                                let n1 = result[0];
                                                let n2 = result[1];
                                                let n3 = result[2];
                                                let n4 = result[3];
                                                let n5 = result[4];

                                                if (n1 == n2) {
                                                    isWinner = true;
                                                }
                                                if (n2 === n3) {
                                                    isWinner = true;
                                                }
                                                if (n3 === n4) {
                                                    isWinner = true;
                                                }
                                                if (n4 === n5) {
                                                    isWinner = true;
                                                }
                                                
                                                if(isWinner){
                                                    profit = data.amount / 3
                                                }
                                            }

                assert(result)

                UserRule.updateBetAfterFinish(gid, id, profit, result, hash, (res, error) => {
                    if (error) {
                        console.log('Error on updateBetAfterFinish on Bots');
                        return false
                    };

                    UserRule.getNameByIdForBots(id, (name) => {
                        if (name && data.coin && data.amount) {
                            let array = {
                                direct: true,
                                gid: gid,
                                uid: id,
                                name: name,
                                created: Date.now(),
                                amount: H.CryptoSet(data.amount, data.coin),
                                profit: H.CryptoSet(profit, data.coin),
                                result: result,
                                hash: hash,
                                game: game,
                                coin: data.coin
                            }

                            let win = true;

                            if (profit === 0.00000000) {
                                win = false;
                                profit = data.amount; // Must Be reduce from profit
                            }

                            //Update User Profit
                            UserRule.updateProfit(true, win, id, profit, data.coin, (isOk) => {
                                H.wait(1200).then(() => {
                                    // Boardcast New Bet to All Clients
                                    io.emit(C.ADD_BET, encode(array));
                                })
                            })
                        }
                    })
                })
            })
        }
    })
}

/**
 * Bots Idle
 */
Bots.Idle = function (io) {
    Play(io);
}

module.exports = Bots;