const _ = require("lodash");
const assert = require("assert");
const Rule = require("../Rule");
const { encode } = require("../../General/Buffer");
const C = require("../../General/Constant");
const H = require("../../General/Helper");
const Result = require("./Result");
const { decide ,roundCompleted} = require('../../gameEngine/GameOutcomeEngine');

class ClassicDice {
  constructor(io, client, data, id) {
    this.io = io;
    this.client = client;
    this.data = data;
    this.id = _.toNumber(id);
  }

  /*
   * Send Data To Client
   */
  emit(data) {
    this.client.emit(C.PLAY_CLASSIC_DICE, encode(data));
  }

  /*
   * Intialize Game
   */
  init() {
    return this.play();
  }

  /*
   * Play Game
   */
  play() {
    let self = this;

    Rule.CanPlay(
      self.id,
      self.data,
      self.client,
      "classic_dice",
      (can, err) => {
        if (can !== true) {
          return self.emit({
            command: "error",
            uid: self.id,
            message: can,
            code: err,
          });
        }

        Rule.preparePlay(
          self.client,
          self.id,
          "classic_dice",
          self.data,
          (isOk) => {
            if (!isOk) {
              console.log("Error Classic Dice Playing: 21");
              return false;
            }

            //Game Bet Amount / Payout Range [ 1 - 100 ] / Chance Range value
            let { amount, payout, chance, type1 } = self.data;

            assert(amount && payout);
            assert(payout > 0);
            assert(chance > 0);

            chance = Math.min(98, chance);

            amount = _.toNumber(amount);

            if (!payout || payout == "undefined") payout = 1.98;

            if (type1 === "Under") {
              payout = Math.min(49.98, payout);
            } else {
              payout = Math.min(49.02, payout);
            }

            payout = _.toNumber(payout);

            var roll = chance.toFixed(2);

            //Security
            if (payout < 1) return;

            Rule.checkLimited(self.id, self.data.coin, async (status) => {
              //Generate Random Hash and Result
              const type = await decide(self.id, 'classic_dice', self.data.coin);
              console.log('decided type1:', type1);
              let randomResult = Result.make(status, self.data,type);
              let hash = randomResult.hash;
              let result = randomResult.result;

              // result multiplier
              let calc = result.toFixed(2);

              //Send Play Game
              self.emit({ command: "play", target: calc });

              payout = _.toNumber(payout);
              calc = _.toNumber(calc);

              //Default Values
              let isWinner = false;
              let profit = 0.0;
              

              console.log('calc:', calc, 'roll:', roll, 'payout:', payout);
                // If the result is lower than payout range, then client is winner.
                if (calc < roll) {
                  isWinner = true;
                }
                else if (calc > roll) {
                  isWinner = false;
                }
              

              if (isWinner) 
              {
                profit = amount * payout - amount;
              }
              else
              {
                profit = -amount;
              }
               

              profit = H.CryptoSet(profit, self.data.coin);

              console.log('prpgit ' + [profit]);

              //Busted Game
              H.wait(50).then(() => {
                Rule.prepareBusted(
                  self.client,
                  self.io,
                  self.id,
                  "classic_dice",
                  self.data,
                  profit,
                  result,
                  hash,
                  isWinner,
                  async (res, gid) => { // Now receives both res and gid
      console.log('Busted Result:', isWinner, 'selfid:', self.id);
      console.log('Busted Data:', self.data);
      console.log("res", res);
      console.log("gid", gid);
                    if (res) {
                      self.emit({
                        command: "busted",
                        profit: profit,
                      });
                      let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
                      await roundCompleted(gid, self.id, self.data.coin, val)
                    }
                  }
                );
              });
            });
          }
        );
      }
    );
  }
}

module.exports = ClassicDice;
