const Players = {

    q: [],

    /*
     * Clear All Jobs
    */
    clear: function () {
        this.q = []
    },

    /*
     * Get All Queue Jobs
    */
    all: function () {
        return this.q;
    },

    /*
     * Add a Job
    */
    set: function (obj) {
        this.q.push(obj);
    },

    /*
     * Get a Target Queue Job
    */
    get: function (uid) {
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].uid === uid) {
                return this.q[i];
            }
        }
        return false;
    },

    /*
     * Update a Key of Target Job
    */
    update: function (uid, key, val) {
        var done = false;
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].uid === uid) {
                this.q[i][key] = val;
                done = true;
            }
        }
        return done;
    },

    /*
     * Remove a Job
    */
    remove: function (uid) {
        var done = false;
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].uid === uid) {
                this.q.splice(i, 1); i--;
                done = true;
            }
        }
        return done;
    },

    /*
     * Exists Job by Uid
    */
    exists: function (uid) {
        let has = false;
        for (var i = 0; i < this.q.length; i++) {
            if (this.q[i].uid === uid) {
                has = true;
            }
        }
        return has;
    }
};

/* Export Players Module */
module.exports = Players;