"use strict";

//Required Libs
const SHA256 = require("crypto-js/sha256");
const _ = require("lodash");
const UsersRule = require("../../Users/Rule");

// Declare Random object
const Random = {};

Random.generateResult = function (lastHash, amount, bank) {
  var gameHash = lastHash != "" ? genGameHash(lastHash) : hash;
  var gameCrash = crashPoint(
    lastHash != "" ? genGameHash(lastHash) : hash,
    amount,
    bank
  );
  lastHash = gameHash;
  return { hash: gameHash, crash: gameCrash };
};

/*
 * Make Result by bankroll
 */
function _crashPoint(seed, amount, bank) {
  const calcWinning = (amount, cashout) => {
    var winning = amount * (cashout - 1);
    return parseFloat(winning);
  };
  const calculateTimeout = (crash_num) => {
    return Math.log(crash_num) * Math.log(Math.E) * 6e-5;
  };
  var calculate = calcWinning(parseFloat(amount), parseFloat(bank) * 10000000);
  var timeout = calculateTimeout(parseFloat(amount) * 10000000);
  let reduce = parseFloat(bank) - calculate;
  return timeout;
}

/*
 * Make Result by Seed
 */
function crashPoint(seed, players, bank) {
  let hash = genGameHash(seed);
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  let max = (result / 100).toFixed(2);
  max = Math.max(1.0, max);
  return max;
}

/*
 * Make SHA256
 */
function genGameHash(serverSeed) {
  return SHA256(serverSeed).toString();
}

/*
 * Calculate Winning
 */
Random.calculateWinning = function (amount, timeStart, isHuman) {
  var ts = new Date();
  var rate = Math.pow(Math.E, 6e-5 * (ts - timeStart)).toFixed(2);

  if (isHuman === true) {
    rate = timeStart;
  }

  var winning = amount * (rate - 1);
  return { cashout: rate, won: winning };
};

/*
 * calculate Timeout
 */
Random.calculateTimeout = function (crash_num) {
  return Math.log(crash_num) / Math.log(Math.E) / 6e-5;
};

// Export the Random module
module.exports = Random;
