const _ = require('lodash');
// const assert = require('assert');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Rule = require('../Rule');
const Result = require('./Result');
const { decide, roundCompleted } = require('../../gameEngine/GameOutcomeEngine');

class Diamond {
	constructor(io, client, data, id) {
		this.io = io
		this.client = client
		this.data = data
		this.id = _.toNumber(id)
	}

	/*
	   * Send Data To Client
	*/
	emit(data) {
		this.client.emit(C.PLAY_DIAMOND, encode(data))
	}

	/*
	 * Intialize Game
	*/
	init() {
		return this.play();
	}

	/*
	 * Play Game
	*/
	play() {
		let self = this;
		Rule.CanPlay(self.id, self.data, self.client, 'diamond', (can, err) => {
			if (can !== true) {
				return this.emit({ command: 'error', uid: self.id, message: can, code: err })
			}

			Rule.checkLimited(self.id, self.data.coin, (status) => {
				console.log("hellokhsbkjhcb");
				Rule.preparePlay(self.client, self.id, 'diamond', self.data, async (isOk) => {
					if (!isOk) {
						console.log('Error Hash Dice Playing: 102')
						return false;
					}
					
				const  type = await decide(self.id, 'diamond', self.data.coin);
				console.log('iugdc',type);
					//Game Bet Amount
					let { amount } = self.data;

					if (!amount) return;

					amount = _.toNumber(amount);

					//Generate Random Hash and Result
					let randomResult = Result.make(type);
					let hash = randomResult.hash;
					let result = randomResult.result;

					//Send Play Game
					self.emit({ command: 'play', target: result })

					//Default Values
					let isWinner = false;
					let profit = 0.00000000;

					let n1 = result[0];
					let n2 = result[1];
					let n3 = result[2];
					let n4 = result[3];
					let n5 = result[4];

					if (n1 == n2) {
						isWinner = true;
					}
					if (n2 === n3) {
						isWinner = true;
					}
					if (n3 === n4) {
						isWinner = true;
					}
					if (n4 === n5) {
						isWinner = true;
					}

					if (isWinner) {
						profit = amount / 3
					}
					else
					{
						profit = -amount;
					}

					profit = H.CryptoSet(profit, self.data.coin);

					//Busted Game
					H.wait(4000).then(() => {
						Rule.prepareBusted(self.client, self.io, self.id, 'diamond', self.data, profit, result, hash, isWinner, async (res, gid) => { // Now receives both res and gid
      console.log('Busted Result:', isWinner, 'selfid:', self.id);
      console.log('Busted Data:', self.data);
      console.log("res", res);
      console.log("gid", gid);
							if (res) {
								self.emit({ command: 'busted', profit: profit })
							let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
                      await roundCompleted(gid, self.id, self.data.coin, val)
                    }
						})
					})
				})
			});
		})
	}
}

module.exports = Diamond;