const assert = require('assert');
const _ = require('lodash');
const Rule = require('../Rule');
const Hash = require('../Hash');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Result = require('./Result');
const { decide, roundCompleted } = require('../../gameEngine/GameOutcomeEngine');

class Goal {
    constructor(io, client, data, id) {
        this.io = io
        this.data = data
        this.client = client
        this.id = _.toNumber(id)
    }

    /*
     * Send Data To Client
     */
    emit(data) {
        this.client.emit(C.PLAY_GOAL, encode(data))
    }

    /*
     * Intialize Game
     */
    init() {
        let {
            command
        } = this.data;

        switch (command) {
            case 'play':
                return this.play();

            case 'clicked':
                return this.clicked();

            case 'cashout':
                return this.end();
        }
    }

    /*
     * Play Game
     */
    play() {
        let self = this;

        Rule.CanPlay(self.id, self.data, self.client, 'goal', (can, err) => {
            if (can !== true) {
                return this.emit({
                    command: 'error',
                    uid: self.id,
                    message: can,
                    code: err
                })
            }

            Rule.preparePlay(self.client, self.id, 'goal', self.data, (isOk) => {
                if (!isOk) {
                    console.log('Error Goal Playing: 59')
                    return false;
                }

                //Generate Random Hash and Result
                let rand = Hash.make();
                let hash = rand.hash;
                let result = Result.generateMines(hash, 4);

                //Update Queue and Save Result, Mines, Hash
                Queue.update(self.id, 'uid', 'result', result);
                Queue.update(self.id, 'uid', 'hash', hash);
                Queue.update(self.id, 'uid', 'selected', []);
                Queue.update(self.id, 'uid', 'profit', 0);

                //Send Play Game
                this.emit({
                    command: 'play'
                })
            })
        })
    }

    /*
     * Click On the Land
     */
    clicked() {
        //Choosed Land
        let { land } = this.data;

        if (!land) return;

        //Get The Client Game Info
        let info = Queue.getOne('uid', this.id)

        if (!info) {
            console.log('Client Not Playing!')
            return false;
        }

        let hash = info.hash;
        let result = info.result;
        let selected = info.selected;
        let coin = info.data.coin;
        let amount = info.data.amount;

        if (!amount || !coin || !result) return;

        land = parseInt(land);

        // Check repeated land ( Security )
        if (_.includes(selected, land)) {
            return console.log('err -2');
        } else {
            selected.push(land)
        }

        //Check Limit Profit
        Rule.checkLimited(this.id, this.data.coin, async (status) => {
            var bomb = false;
            console.log("bshjkcb",this.id);
            land = this.fixLand(land);
            const type = await decide(this.id, 'goal', coin);
            console.log("dcuh",type);
            result.forEach((number, i) => {
                if (parseFloat(land) === parseFloat(number.num))
                    bomb = true;
            });

            //Limit Profit
            if (type === 'force_loss') {
                result = _.drop(result, 1);
                result.push({
                    num: land,
                    hash: hash
                });
                bomb = true;
            }

            if (bomb) {
                //Bomb ! let's End Game.
                return this.lost(result, hash);
            } else {
                //Safe ! let's Send Bonus.
                return this.setBonus(amount, coin, land);
            }
        })
    }

    /*
     * Set Bonus
     */
    setBonus(amount, coin, land) {
        let self = this;
        var info = Queue.getOne('uid', self.id);
        let result = Result.generateMines(info.hash, 4);
        Queue.update(self.id, 'uid', 'result', result);
        let profit = (_.toNumber(amount) * 3) / 10;
        profit = H.CryptoSet(profit, coin);
        let plus = _.toNumber(info.profit) + _.toNumber(profit);
        Queue.update(this.id, 'uid', 'profit', plus);
        return this.emit({
            command: 'clicked',
            profit: profit,
            coin: coin,
            id: land
        })
    }

    /*
     * End Game / Client Lost
     */
    lost(result, hash) {
          //Get The Client Game Info
          let info = Queue.getOne('uid', this.id)
        let profit = -info.data.amount;
        let isWinner = false;
        Rule.prepareBusted(this.client, this.io, this.id, 'goal', this.data, profit, result, hash, isWinner, async(res,gid) => {
            console.log(gid);
            
            return this.emit({
                command: 'busted',
                profit: profit,
                mines: result
            });
           
        })
    }

    /*
     * CashOut / End the Game / Client Win
     */
    end() {
        // let { profit } = this.data;

        //Get The Client Game Info
        let info = Queue.getOne('uid', this.id)

        if (!info) {
            console.log('Client Not Playing!')
            return false;
        }

        let result = info.result;
        let mines = info.mines;
        let hash = info.hash;
        let profit = info.profit;

        let isWinner = true;

        Rule.prepareBusted(this.client, this.io, this.id, 'goal', info.data, profit, result, hash, isWinner, async(res,gid) => {
            console.log("ghchgcghch");
            console.log("hhgv",gid);
            console.log("jvh",info.data);
            console.log("bhb",this.id);
            if (res) {
                this.emit({
                    command: 'cashout',
                    profit: profit,
                    mines: result
                })
                
            }
            let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
                      await roundCompleted(gid, this.id, info.data.coin, val);
        })
    }

    fixLand(land) {
        if (land === 5)
            land = 1;
        else if (land === 6)
            land = 2;
        else if (land === 7)
            land = 3;
        else if (land === 8)
            land = 4;
        else if (land === 9)
            land = 1;
        else if (land === 10)
            land = 2;
        else if (land === 11)
            land = 3;
        else if (land === 12)
            land = 4
        else if (land === 13)
            land = 1
        else if (land === 14)
            land = 2
        else if (land === 15)
            land = 3
        else if (land === 16)
            land = 4

        return land;
    }
}

module.exports = Goal;