const _ = require('lodash');
const assert = require('assert');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Rule = require('../Rule');
const Result = require('./Result');
const { decide ,roundCompleted} = require('../../gameEngine/GameOutcomeEngine');

class HashDice {
	constructor(io, client, data, id) {
		this.io = io
		this.client = client
		this.data = data
		this.id = _.toNumber(id)
	}

	/*
	   * Send Data To Client
	*/
	emit(data) {
		this.client.emit(C.PLAY_HASH_DICE, encode(data))
	}

	/*
	 * Intialize Game
	*/
	init() {
		return this.play();
	}

	/*
	 * Play Game
	*/
	play() {
		let self = this;
		Rule.CanPlay(self.id, self.data, self.client, 'hash_dice', (can, err) => {
			if (can !== true) {
				return this.emit({ command: 'error', uid: self.id, message: can, code: err })
			}

			Rule.checkLimited(self.id, self.data.coin, (status) => {
				Rule.preparePlay(self.client, self.id, 'hash_dice', self.data, async (isOk) => {
					if (!isOk) {
						console.log('Error Hash Dice Playing: 102')
						return false;
					}

					//Game Bet Amount
					let { amount, type, payout } = self.data;

					if (!amount && !type && !payout) return;
					console.log("dsbc",type);

					if (_.isUndefined(payout))
						payout = '1.98';

					assert(payout > 0);

					amount = _.toNumber(amount);
					payout = _.toNumber(payout);
					payout = payout.toFixed(2)
					console.log("sdnjsc",self.id);
					console.log("kbjdc",self.data.coin);
					const  val = await decide(self.id, 'hash_dice', self.data.coin);
					console.log("jkscjknd",val);

					//Generate Random Hash and Result
					let randomResult = Result.make(status, type,val);
					console.log("cjasnc",randomResult);
					let hash = randomResult.hash;
					let result = randomResult.result;

					result = _.toNumber(result);

					//Send Play Game
					self.emit({ command: 'play', target: result })

					//Default Values
					let isWinner = false;
					let profit = 0.00000000;

					if (type === 'high') {
						if (result > 50000) {
							isWinner = true;
							profit = (payout * amount) - amount;
						}
						else{
							isWinner = false;
							profit = -amount;
						}
					}
					else if(type !== 'high') {
						if (result < 49999) {
							isWinner = true;
							profit = (payout * amount) - amount;
						}
						else{
							isWinner = false;
							profit = -amount;
						}
					}
					else
					{
						isWinner = false;
						profit = -amount;

					}

					profit = H.CryptoSet(profit, self.data.coin);

					//Busted Game
					H.wait(2000).then(() => {
						Rule.prepareBusted(self.client, self.io, self.id, 'hash_dice', self.data, profit, result, hash, isWinner, async (res, gid) => { // Now receives both res and gid
      console.log('Busted Result:', isWinner, 'selfid:', self.id);
      console.log('Busted Data:', self.data);
      console.log("res", res);
      console.log("gid", gid);
							if (res) {
								self.emit({ command: 'busted', profit: profit })
								let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
                      await roundCompleted(gid, self.id, self.data.coin, val)
							}
						})
					})
				})
			});
		})
	}
}

module.exports = HashDice;