"use strict";

//Random Generate Hash/Result

//Required Libs
var SHA256 = require("crypto-js/sha256");
var H = require("../../General/Helper");

const Result = {};

Result.make = function (canProfit, type) {
  let hash = makeHash();
  let result = makeResult(hash, type, canProfit);
  return { hash, result };
};

function makeHash() {
  var key = "00000000000000" + randomString(50);
  var gameHash = SHA256(key).toString();
  return gameHash;
}

function makeResult(seed, type, canProfit) {
  let hash = SHA256(seed).toString();
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  result = (result / 100).toFixed(2);
  result = result * 80;
  result = result.toFixed(0);
  result = Math.max(100, result);

  return result;

  //Limit Profit
  // if (!canProfit) {
  //     if (type === 'high') {
  //         if (result > 500) {
  //             return H.getRandomBetween(100, 480);
  //         }
  //     }
  //     else if (type === 'low') {
  //         if (result < 500) {
  //             return H.getRandomBetween(501, 999);
  //         }
  //     }
  //     else if (type === 'equal') {
  //         if (result === 111 || result === 222 || result === 333 || result === 444 || result === 555 || result === 666 || result === 7 || result === 8 || result === 999) {
  //             return H.getRandomBetween(100, 999);
  //         }
  //     }

  //     return result;
  // }
  // else return result
}

function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

// Export the Result module
module.exports = Result;
