const _ = require('lodash');
const assert = require('assert');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Rule = require('../Rule');
const Queue = require('../../General/Queue');
const Result = require('./Result');

class HashDice {
    constructor(io, client, data, id) {
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id)
    }

    /*
       * Send Data To Client
    */
    emit(data) {
        this.client.emit(C.PLAY_HIGHLOW, encode(data))
    }

    /*
     * Intialize Game
    */
    init() {
        return this.play();
    }

    /*
     * Play Game
    */
    // play() {
    //     let self = this;
    //     Rule.CanPlay(self.id, self.data, self.client, 'high_low', (can, err) => {
    //         if (can !== true) {
    //             return this.emit({ command: 'error', uid: self.id, message: can, code: err })
    //         }

    //         Rule.checkLimited(self.id, self.data.coin, (status) => {
    //             Rule.preparePlay(self.client, self.id, 'high_low', self.data, (isOk) => {
    //                 if (!isOk) {
    //                     console.log('Error High or Low Playing: 102')
    //                     return false;
    //                 }

    //                 //Game Bet Amount
    //                 let { amount, type } = self.data;

    //                 if (!amount && !type) return;

    //                 amount = _.toNumber(amount);

    //                 //Generate Random Hash and Result
    //                 let randomResult = Result.make(status, type);
    //                 let hash = randomResult.hash;
    //                 let result = randomResult.result;

    //                 result = _.toNumber(result);

    //                 let sResult = result.toString();

    //                 //Send Play Game
    //                 let rand = [];
    //                 for (var i = 0; i < 3; i++) {
    //                     rand.push(sResult[i]);
    //                 }

    //                 self.emit({ command: 'play', target: rand })

    //                 //Default Values
    //                 let isWinner = false;
    //                 let profit = 0.00000000;

    //                 if (type === 'high') {
    //                     if (result > 500) {
    //                         isWinner = true;
    //                     }
    //                 }
    //                 else if(type === 'low') {
    //                     if (result < 500) {
    //                         isWinner = true;
    //                     }
    //                 }
    //                 else if(type === 'equal'){
    //                     if (result === 111 || result === 222 || result === 333 || result === 444 || result === 555 || result === 666 || result === 7 || result === 8 || result === 999) {
    //                         isWinner = true;
    //                     }
    //                 }
    //                 else {
    //                     return 'hack highlow -3';
    //                 }

    //                 if (isWinner) {
    //                     // profit = 3 ? (amount * 3 - (amount / 2)) / 4 : 0.00000004
    //                     profit=amount;
    //                 }
    //                 else
    //                 {
    //                     profit=-amount;
    //                 }

    //                 console.log(result)

    //                 profit = H.CryptoSet(profit, self.data.coin);

    //                 //Busted Game
    //                 H.wait(2000).then(() => {
    //                     Rule.prepareBusted(self.client, self.io, self.id, 'high_low', self.data, profit, result, hash, isWinner, (res) => {
    //                         if (res) {
    //                             self.emit({ command: 'busted', profit: profit })
    //                         }
    //                     })
    //                 })
    //             })
    //         });
    //     })
    // }
    play() {
        let self = this;
        
        // Step 1: Validate if the player can play
        Rule.CanPlay(self.id, self.data, self.client, 'high_low', (can, err) => {
            if (can !== true) {
                return this.emit({ command: 'error', uid: self.id, message: can, code: err });
            }
    
            // Step 2: Check if the player is within the coin limits
            Rule.checkLimited(self.id, self.data.coin, (status) => {
                
                // Step 3: Prepare the game for playing
                Rule.preparePlay(self.client, self.id, 'high_low', self.data, (isOk) => {
                    if (!isOk) {
                        console.log('Error High or Low Playing: 102');
                        return false;
                    }
    
                    // Game Bet Amount
                    let { amount, type } = self.data;
    
                    // Validate amount and type before proceeding
                    if (!amount || !type) return;
    
                    amount = _.toNumber(amount);  // Convert amount to number
    
                    // Step 4: Generate Random Result and Hash
                    let randomResult = Result.make(status, type);
                    let hash = randomResult.hash;
                    let result = _.toNumber(randomResult.result);  // Ensure result is a number
    
                    let sResult = result.toString();
    
                    // Step 5: Send Play Game event with sliced result (3 characters)
                    let rand = [];
                    for (var i = 0; i < 3; i++) {
                        rand.push(sResult[i]);
                    }
                    self.emit({ command: 'play', target: rand });
    
                    // Step 6: Initialize win/loss logic
                    let isWinner = false;
                    let profit = 0.00000000;  // Default profit
    
                    // Step 7: Game Logic - Determine if the user won based on their bet type
                    if (type === 'high') {
                        if (result > 500) {
                            isWinner = true;
                        }
                    } else if (type === 'low') {
                        if (result < 500) {
                            isWinner = true;
                        }
                    } else if (type === 'equal') {
                        if ([111, 222, 333, 444, 555, 666, 7, 8, 999].includes(result)) {
                            isWinner = true;
                        }
                    } else {
                        return 'hack highlow -3';  // Invalid type
                    }
    
                    // Step 8: Calculate profit based on win/loss
                    profit = isWinner ? amount : -amount;  // Positive profit if win, negative if loss
    
                    console.log('Game result:', result);
                    console.log('Profit calculated:', profit);
    
                    // Convert profit using CryptoSet method
                    profit = H.CryptoSet(profit, self.data.coin);
    
                    // Step 9: Delay and handle busted game result
                    H.wait(2000).then(() => {
                        Rule.prepareBusted(self.client, self.io, self.id, 'high_low', self.data, profit, result, hash, isWinner, (res) => {
                            if (res) {
                                self.emit({ command: 'busted', profit: profit });
                            }
                        });
                    });
                });
            });
        });
    }
    
}

module.exports = HashDice;