'use strict';

//Required Libs
var CryptoJS = require("crypto-js");
var SHA256 = require("crypto-js/sha256");

// Declare Random object
const Random = {};

Random.generateResult = function (lastHash) {
    function generateResult() {
        var gameHash = (lastHash != "" ? genGameHash(lastHash) : hash);
        var gameCrash = keno((lastHash != "" ? genGameHash(lastHash) : hash));
        lastHash = gameHash;
        return { hash: gameHash, crash: gameCrash };
    }

    function genGameHash(serverSeed) {
        return SHA256(serverSeed).toString();
    }

    function seedGenerator(hash, salt) {
        const hmac = CryptoJS.HmacSHA256(CryptoJS.enc.Hex.parse(hash), salt);
        return hmac.toString(CryptoJS.enc.Hex);
    }

    function createNums(n, hash) {
        if (n === undefined || n == 'undefined') return;

        const nums = [];
        let h = CryptoJS.SHA256(hash).toString(CryptoJS.enc.Hex);
        n.forEach((c) => {
            nums.push({ num: c, hash: h });
            h = h.substring(1) + h.charAt(0);
        });
        nums.sort(function (o1, o2) {
            if (o1.hash < o2.hash) {
                return -1;
            } else if (o1.hash === o2.hash) {
                return 0;
            } else {
                return 1;
            }
        });
        return nums;
    }

    function keno(hash) {
        const salt = 'salt waiting to be generated';
        const allNums = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
            19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40];
        const seed = seedGenerator(hash, salt);
        let finalNums = createNums(allNums, seed);
        finalNums = createNums(finalNums, seed);
        return finalNums.slice(0, 10).map(m => m.num)
    }

    return generateResult(lastHash);
}

// Export the Random module
module.exports = Random;