const _ = require('lodash');
const Rule = require('../Rule');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const H = require('../../General/Helper');
const C = require('../../General/Constant');
const Result = require('./Result');

class MagicWheel {
        constructor(io, client, data, id) {
                this.io = io
                this.client = client
                this.data = data
                this.id = _.toNumber(id);
        }

        /*
         * Send Data To Client
         */
        emit(data) {
                this.client.emit(C.PLAY_MAGIC_WHEEL, encode(data))
        }

        /*
         * Intialize Game
         */
        init() {
                let { command } = this.data;

                switch (command) {
                        case 'play':
                                return this.play();
                        case 'busted':
                                return this.busted();
                }
        }

        /*
         * Play Game
         */
        play() {
                let self = this;

                Rule.CanPlay(self.id, self.data, self.client, 'magic_wheel', (status, err) => {
                        if (status !== true) {
                                return this.emit({
                                        command: 'error',
                                        uid: self.id,
                                        message: status,
                                        code: err
                                })
                        }

                        Rule.preparePlay(self.client, self.id, 'magic_wheel', self.data, (isOk) => {
                                if (!isOk) {
                                        console.log('Error Magic Wheel Playing: 21')
                                        return false;
                                }

                                Rule.checkLimited(self.id, self.data.coin, (status) => {
                                        //Generate Random Hash 
                                        let rand = Result.make(status);
                                        let result = rand.result;
                                        let hash = rand.hash;

                                        //Update Queue and Save Result and Hash
                                        Queue.update(self.id, 'uid', 'hash', hash);
                                        Queue.update(self.id, 'uid', 'result', result);

                                        //Send Play Game
                                        this.emit({
                                                command: 'play',
                                                hash: hash,
                                                target: result
                                        });
                                })
                        })
                })
        }

        /*
         * End / Busted Game
         */
        busted() {
                let self = this;

                // let { bonus } = self.data;

                //Get The Client Game Info
                let info = Queue.getOne('uid', self.id);

                let b = info.result;
                let bonus = b[2];

                if (bonus === 'NEXT') {
                        bonus = b[1];
                }

                if (bonus === 'NEXT') {
                        bonus = b[0];
                }

                if (!info) {
                        console.log('Client Not Playing Magic Wheel!', self.id)
                        return false;
                }

                let hash = info.hash;
                let result = parseFloat(bonus)
                let amount = _.toNumber(info.data.amount);

                if (result === NaN || result === 'NaN' || _.isNaN(result))
                        return console.log('error on nan bonus - magic wheel')

                let profit = 0.00000000;
                let isWinner = false;

                if (result !== 24) {
                        isWinner = true;
                        profit = (amount * 3 - (amount / 2)) / 4;
                }
                else
                {
                        isWinner = false;
                        profit = -amount;
                }

                profit = H.CryptoSet(profit, info.data.coin);

                Rule.prepareBusted(self.client, self.io, self.id, 'magic_wheel', info.data, profit, result, hash, isWinner, (res) => {
                        if (res) {
                                self.emit({
                                        command: 'busted',
                                        profit: profit
                                })
                        }
                })
        }
}

module.exports = MagicWheel;