const _ = require('lodash');
const assert = require('assert');
const Rule = require('../Rule');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Result = require('./Result');

class Roulette {
    constructor(io, client, data, id) {
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id);
    }

    /*
     * Send Data To Client
     */
    emit(data) {
        this.client.emit(C.PLAY_ROULETTE, encode(data))
    }

    /*
     * Intialize Game
     */
    init() {

        let { command } = this.data;

        switch (command) {
            case 'play':
                return this.play();
            case 'busted':
                return this.busted();
        }
    }

    /*
     * Play Game
     */
    play() {
        let self = this;

        // var amount = _.sumBy(self.data, function(o) { return _.toNumber(o.amount); });
        // let arr = {amount: amount, coin: self.data.coin };

        var amount = 0;

        self.data.data.forEach((item, i) => {
            amount += parseFloat(item.amount);
        })

        amount = H.CryptoSet(amount);

        if (parseFloat(amount) === 0) {
            return self.emit({
                command: 'error',
                uid: self.id,
                message: 'Please place a bet',
            });
        }

        if (amount < 0) return console.log('hack roulette');

        assert(amount > 0);

        let arr = {
            amount: amount,
            coin: self.data.coin
        };

        Rule.CanPlay(self.id, arr, self.client, 'roulette', (status, err) => {
            if (status !== true) {
                return self.emit({
                    command: 'error',
                    uid: self.id,
                    message: status,
                    code: err
                })
            }

            Rule.preparePlay(self.client, self.id, 'roulette', arr, (isOk) => {
                if (!isOk) {
                    console.log('Error Roulette Playing: 21')
                    return false;
                }

                Rule.checkLimited(self.id, self.data.coin, (status) => {

                    //Generate Random Hash and Result
                    let randomResult = Result.make();
                    let result = randomResult.result
                    let hash = randomResult.hash

                    //Update Queue and Save Result and Hash
                    Queue.update(self.id, 'uid', 'hash', hash);
                    Queue.update(self.id, 'uid', 'result', result);
                    Queue.update(self.id, 'uid', 'game_data', self.data.data);

                    //Send Play Game
                    this.emit({ command: 'play', hash: hash, target: result });

                    //Busted Game
                    H.wait(15000).then(() => {
                        this.busted();
                    })
                })
            })
        })
    }

    /*
     * End / Busted Game
     */
    busted() {
        let self = this;
        // let { profit } = self.data;

        //Get The Client Game Info
        let info = Queue.getOne('uid', self.id)

        if (!info) {
            console.log('Client Not Playing!', self.id)
            return false;
        }

        let hash = info.hash;
        let result = info.result;
        let game_data = info.game_data;

        var table = findTableByNumber(result);

        let profit = 0.00000000;

        const row1 = [3, 6, 9, 12, 15, 18, 12, 24, 27, 30, 33, 36];
        const row2 = [2, 5, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35];
        const row3 = [1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34];

        const even = [2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36];
        const odd = [1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35];

        const reds = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
        const blacks = [2, 4, 6, 8, 10, 11, 13, 15, 17, 20, 22, 24, 26, 28, 29, 31, 33, 35];

        game_data.forEach(function (value) {

            if (value.table === '2_1') {
                row1.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === '2_2') {
                row2.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === '2_3') {
                row3.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === '1_18') {
                for (var i = 1; i < 18; i++) {
                    let targetTable = findTableByNumber(i);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                }
            }
            else if (value.table === '19_36') {
                for (var i = 19; i < 37; i++) {
                    let targetTable = findTableByNumber(i);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                }
            }
            else if (value.table === 'even') {
                even.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === 'odd') {
                odd.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === 'red') {
                reds.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else if (value.table === 'black') {
                blacks.forEach(function (n) {
                    let targetTable = findTableByNumber(n);
                    if (targetTable === table) {
                        profit += parseFloat(value.amount)
                    }
                })
            }
            else {
                let choosedTable = findTableByNumber(value.table);
                if (choosedTable === table) {
                    profit += parseFloat(value.amount)
                }
            }
        });

        let isWinner = false;

        if (profit !== 0.00000000) {
            isWinner = true;
            profit /= 3
        }

        profit = H.CryptoSet(profit);

        // let newResult = { result, game_data };
        let newResult = result

        Rule.prepareBusted(self.client, self.io, self.id, 'roulette', info.data, profit, newResult, hash, isWinner, (res) => {
            if (res) {
                self.emit({
                    command: 'busted',
                    profit: profit
                })
            }
        })
    }
}

function findTableByNumber(number) {
    // 1st 12
    if (number === 112) {
        return 1;
    }

    // 2nd 12
    if (number === 212) {
        return 2;
    }

    // 3rd 12
    if (number === 312) {
        return 3;
    }

    //Single Numbers

    if (number === 0) return 0;

    if (number <= 12)
        return 1;

    if (number >= 13 && number <= 22)
        return 2;

    if (number >= 25 && number <= 36)
        return 3;
}

module.exports = Roulette;