'use strict';

const _ = require('lodash');
const CryptoJS = require("crypto-js");

//Generate Random Result

const Result = {};

/*
 * Generate Keno Result
*/
Result.keno = function (hash, cantProfit, userNums, type) {

    console.log('Result.keno called with hash:', hash, 'cantProfit:', cantProfit, 'userNums:', userNums);
    console.log('cdkmc', type)
    const salt = 'salt waiting to be generated';
    let allNums = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40
    ];
    if (type === "force_win") {
        // Force win: generate result <= payout
       
        const otherNums = _.xor(allNums, userNums);
      
        const randomNum = Math.floor(Math.random() * 3) + 4;
        userNums.splice(0, randomNum);
    

        const seed = seedGenerator(hash, salt);

        // Generate initial numbers
        let finalNums = createNums(userNums, seed);
        finalNums = createNums(finalNums, seed);

        
        // If finalNums has nested structure like [{ num: { num: 6, hash: '...' }, hash: '...' }]
        // we slice it safely and then map to extract .num
        // finalNums = finalNums.slice(0, 10);

        if (finalNums.length < 10) {
            const needed = 10 - finalNums.length;
          
            // Remove already-used numbers to avoid duplicates
            const usedNums = finalNums.map(entry => entry.num?.num || entry.num);
            const remainingOthers = otherNums.filter(n => !usedNums.includes(n));

            // Use hash as deterministic selector
            const additionalNums = [];
            for (let i = 0; i < needed; i++) {
                const hashIndex = (parseInt(hash.slice(i * 2, i * 2 + 2), 16) % remainingOthers.length);
                const num = remainingOthers[hashIndex];

                // Ensure uniqueness
                remainingOthers.splice(hashIndex, 1);

                additionalNums.push({
                    num: {
                        num,
                        hash: hash + i, // Example of varying hash; use proper subhash if needed
                    },
                    hash: hash + i
                });
            }
           

            finalNums = finalNums.concat(additionalNums);
         
        }

        // Final mapping to extract num values
        finalNums = finalNums.slice(0, 10).map(m => m.num);
       
        return finalNums;
    }
    else if (type === "force_loss") {
        // Force loss: generate result > payout
        // cantProfit = true;
        // if(!cantProfit){
        // allNums = _.xor(allNums, userNums);
        // }
        const randomNum = Math.floor(Math.random() * 3) + 1;
        userNums.splice(0, randomNum);
        allNums = _.xor(allNums, userNums);

        const seed = seedGenerator(hash, salt);
        let finalNums = createNums(allNums, seed);
        finalNums = createNums(finalNums, seed);
        finalNums = finalNums.slice(0, 10).map(m => m.num);
        return finalNums;
    }
    else {

        // If cantProfit is false, we will include userNums in the final result
        if (!cantProfit) {
            allNums = _.xor(allNums, userNums);
        }

        const seed = seedGenerator(hash, salt);
        let finalNums = createNums(allNums, seed);
        finalNums = createNums(finalNums, seed);
        finalNums = finalNums.slice(0, 10).map(m => m.num);
        return finalNums;
    }


}

/*
 * Seed Genertator
*/
function seedGenerator(hash, salt) {
    const hmac = CryptoJS.HmacSHA256(CryptoJS.enc.Hex.parse(hash), salt);
    return hmac.toString(CryptoJS.enc.Hex);
}

/*
 * Create Keno Numbers
*/
function createNums(allNums, hash) {
    const nums = [];
    let h = CryptoJS.SHA256(hash).toString(CryptoJS.enc.Hex);
    allNums.forEach((c) => {
        nums.push({
            num: c,
            hash: h
        });
        h = h.substring(1) + h.charAt(0);
    });
    nums.sort(function (o1, o2) {
        if (o1.hash < o2.hash) {
            return -1;
        } else if (o1.hash === o2.hash) {
            return 0;
        } else {
            return 1;
        }
    });
    return nums;
}

// Export the Result module
module.exports = Result;