const _ = require('lodash');
const Rule = require('../Rule');
const Hash = require('../Hash');
const Result = require('./Result');
const {
    encode
} = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const { decide ,roundCompleted} = require('../../gameEngine/GameOutcomeEngine');
class SingleKeno {
    constructor(io, client, data, id) {
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id)
    }

    /*
     * Send Data To Client
     */
    emit(data) {
        this.client.emit(C.PLAY_SINGLE_KENO, encode(data))
    }

    /*
     * Intialize Game
     */
    init() {
        return this.play();
    }

    /*
     * Play Game
     */
    play() {
        let self = this;

        Rule.CanPlay(self.id, self.data, self.client, 'singlekeno', (status, err) => {

            if (status !== true) {
                return self.emit({
                    command: 'error',
                    uid: self.id,
                    message: status,
                    code: err
                })
            }

            Rule.preparePlay(self.client, self.id, 'singlekeno', self.data, (isOk) => {
                if (!isOk) {
                    console.log('Error Single Keno Playing: 45')
                    return false;
                }


                Rule.checkLimited(this.id, this.data.coin, async (status) => {
                
                    //Game Bet data
                    let { amount, numbers } = self.data;
                 
                    const type = await decide(self.id, 'singlekeno', self.data.coin);
                    //Generate Random Hash and Result
                    let randomResult = Hash.make();
                    let hash = randomResult.hash;

                    let arr = [true, false];
                    let rands = arr[H.getRandomInt(arr.length)]; // Random Win or Loss

                    let result = Result.keno(hash, status, numbers,type);

                    //Send Play Game
                    self.emit({ command: 'play' })

                    //Default Values
                    let isWinner = false;
                    let profit = 0.00000000;
                    let win = 0;

                    //Calculate Client is Winner or Lost / Calculate Profit
                    result.forEach((number, i) => {
                        if (numbers.includes(number.num)) {
                            win += 1;
                        }
                    });

                    if (win <= 3) {
                        isWinner = false;
                        profit  = -amount;
                    }
                    else if (win === 4) {
                        isWinner = true;
                        profit = 2 * _.toNumber(amount);
                    }
                    else if (win === 5) {
                        isWinner = true;
                        profit = 3 * _.toNumber(amount);
                    }
                    else if (win === 6) {
                        isWinner = true;
                        profit = 4 * _.toNumber(amount);
                    }
                    else if (win === 7) {
                        isWinner = true;
                        profit = 6 * _.toNumber(amount);
                    }
                    else if (win === 8) {
                        isWinner = true;
                        profit = 10 * _.toNumber(amount);
                    }
                    else if (win === 9) {
                        isWinner = true;
                        profit = 25 * _.toNumber(amount);
                    }
                    else
                    {
                       isWinner = true;
                        profit = 100 * _.toNumber(amount);
                    }

                    profit = H.CryptoSet(profit, self.data.coin);

                    //Busted Game
                    H.wait(150).then(() => {
                        Rule.prepareBusted(self.client, self.io, self.id, 'singlekeno', self.data, profit, result, hash, isWinner, async (res, gid) => { // Now receives both res and gid
      console.log('Busted Result:', isWinner, 'selfid:', self.id);
      console.log('Busted Data:', self.data);
      console.log("res", res);
      console.log("gid", gid);
                            if (res) {
                                self.emit({
                                    command: 'busted',
                                    profit:profit,
                                    numbers: result
                                })
                                let val 
                      if(isWinner){
                         val = 'win'
                      }
                      else{
                          val = 'loss'
                      }
                      await roundCompleted(gid, self.id, self.data.coin, val)
							}
                        })
                    })


                })
            })
        })
    }
}

module.exports = SingleKeno;