const _ = require('lodash');
const assert = require('assert');
const Rule = require('../Rule');
const Hash = require('../Hash');
const Queue = require('../../General/Queue');
const { encode } = require('../../General/Buffer');
const C = require('../../General/Constant');
const H = require('../../General/Helper');
const Result = require('./Result');

class ThreeCardMonte {
    constructor(io, client, data, id) {
        this.io = io
        this.client = client
        this.data = data
        this.id = _.toNumber(id)
    }

    /*
     * Send Data To Client
     */
    emit(data) {
        this.client.emit(C.PLAY_THREE_CARD_MONTE, encode(data))
    }

    /*
     * Intialize Game
     */
    init() {
        let { command } = this.data;

        switch (command) {
            case 'play':
                return this.play();

            case 'clicked':
                return this.clicked();
        }
    }

    /*
     * Play Game
     */
    play() {
        let self = this;

        Rule.CanPlay(self.id, self.data, self.client, '3_cardmonte', (status, err) => {
            if (status !== true) {
                return this.emit({
                    command: 'error',
                    uid: self.id,
                    message: status,
                    code: err
                })
            }

            Rule.preparePlay(self.client, self.id, '3_cardmonte', self.data, (isOk) => {
                if (!isOk) {
                    console.log('Error 3 Card Monte Playing: 21')
                    return false;
                }

                //Generate Random Hash and Result
                let rand = Result.make()
                let result = rand.result;
                let hash = rand.hash;

                //Update Queue and Save Result, Hash
                Queue.update(self.id, 'uid', 'hash', hash);
                Queue.update(self.id, 'uid', 'result', result);

                //Send Play Game
                self.emit({ command: 'play' })
            })
        })
    }

    /*
     * Click On the Land
     */
    clicked() {
        //Choosed Land
        let { target } = this.data;
        console.log("gvgv",target);

        //Get The Client Game Info
        let info = Queue.getOne('uid', this.id)

        if (!info) {
            console.log('Client Not Playing!', this.id)
            return false;
        }

        let hash = info.hash;
        let result = info.result;
        let coin = info.data.coin;
        let amount = info.data.amount;

        if (!amount || !coin) return;

        //Check Limit Profit
        Rule.checkLimited(this.id, this.data.coin, (status) => {

            var winner = false;

            if(result[target] === 'spade'){
            	winner = true
            }
            else{
                winner = false
            }

            // if (!status) {
            //     winner = false;
            // }

            if (winner === false) {
                // let's End Game.
                return this.lost(result, target, hash);
            } else {
                //Safe ! let's Send Bonus.
                return this.setBonus(result, amount, coin, hash);
            }
        })
    }

    /*
     * Set Bonus
     */
    setBonus(result, amount, coin, hash) {
        let profit = _.toNumber(amount) / 2;
        profit = H.CryptoSet(profit, coin);
        Rule.prepareBusted(this.client, this.io, this.id, '3_cardmonte', this.data, profit, result, hash, true, (res) => {
            return this.emit({
            command: 'busted',
            profit: profit,
            result: result,
                win: true
            });
        })
    }

    /*
     * End Game / Client Lost
     */
    lost(result, target, hash) {
        let info = Queue.getOne('uid', this.id)
        let profit = -info.data.amount;
        let isWinner = false;
        Rule.prepareBusted(this.client, this.io, this.id, '3_cardmonte', this.data, profit, target, hash, isWinner, (res) => {
            return this.emit({
                command: 'busted',
                profit: profit,
                result: result,
                win: false
            });
        })
    }
}

module.exports = ThreeCardMonte;