'use strict';

const _ = require('lodash');
const CryptoJS = require("crypto-js");

function random(length) {
    return Math.floor(Math.random() * length);
}

let r = []
for (var i = 1; i < 16; i++) {
    r.push(i)
}

//Generate Random Result

const Result = {};

/*
 * Generate Result
*/
Result.generate = function (hash) {
    const salt = 'salt waiting to be generated';

    let randomNumbers = [];
    for (var i = 1; i < 16; i++) {
        randomNumbers.push(r[random(r.length)])
    }

    var allNums = _.shuffle(randomNumbers)
    allNums = _.xor(allNums);
    var rand = _.drop(allNums, allNums.length - 16)
    const seed = seedGenerator(hash, salt);
    let finalNums = createNums(rand, seed);
    finalNums = createNums(finalNums, seed);
    var result = finalNums.map(m => m.num);
    return result
}

/*
 * Seed Genertator
*/
function seedGenerator(hash, salt) {
    const hmac = CryptoJS.HmacSHA256(CryptoJS.enc.Hex.parse(hash), salt);
    return hmac.toString(CryptoJS.enc.Hex);
}

/*
 * Create Numbers
*/
function createNums(allNums, hash) {
    const nums = [];
    let h = CryptoJS.SHA256(hash).toString(CryptoJS.enc.Hex);
    allNums.forEach((c) => {
        nums.push({
            num: c,
            hash: h
        });
        h = h.substring(1) + h.charAt(0);
    });
    nums.sort(function (o1, o2) {
        if (o1.hash < o2.hash) {
            return -1;
        } else if (o1.hash === o2.hash) {
            return 0;
        } else {
            return 1;
        }
    });
    return nums;
}

// Export the Result module
module.exports = Result;