"use strict";

//Random Generate Hash/Result for all games.

//Required Libs
var SHA256 = require("crypto-js/sha256");
var H = require("../../General/Helper");

const Result = {};

Result.make = function (canProfit) {
  let hash = makeHash();
  let result = makeResult(hash);

  // if (!canProfit) {
  //     result = 0
  // }

  return { hash, result };
};

function makeHash() {
  var key = "00000000000000" + randomString(50);
  var gameHash = SHA256(key).toString();
  return gameHash;
}

function makeResult(seed) {
  let hash = SHA256(seed).toString();
  let h = parseInt(hash.slice(0, 13), 16);
  let e = Math.pow(2, 52);
  let result = Math.floor((98 * e) / (e - h));
  result = (result / 100).toFixed(2);
  result = result * 8880;
  result = result.toFixed(0);
  return result;
}

function randomString(length) {
  var chars = "0123456789abcdefghiklmnopqrstuvwxyz".split("");
  var str = "";
  for (var i = 0; i < length; i++) {
    str += chars[Math.floor(Math.random() * chars.length)];
  }
  return str;
}

// Export the Hash module
module.exports = Result;
