'use strict';

const B = {};

/**
 * Encode Data
 * @param data
 * @return {ArrayBufferLike}
 */
B.encode = function(data){
    try{
        if(!data) return null;
        return Buffer.from(JSON.stringify(data), 'binary');
    } catch(e){
        console.log('BUFFER ERROR ENCODE', e.message)
    }
};

/**
 * Decode Data
 * @param data
 * @return {string}
 */
B.decode = function(data){
    try{
        if(!data) return null;
        var responseData = new TextDecoder().decode(data)
        return JSON.parse(responseData)
    } catch(e){
        console.log('BUFFER ERROR DECODE', e.message)
    }
};

module.exports = B;