/**
 * RedisMiddleware.js
 * 
 * Handles caching of postgres queries
 * (and presumably other stuff)
 * 
 */



var redis = require("redis"), client = redis.createClient();

redis.debug = true;

client.on("error", function(err) {
	console.log("Error " + err);
});

///////////////////////////////////////

function get(key, next) {
	client.get('postgres:' + key, function (err, result) {
		if (err || !result) return next(null);
		return next(JSON.parse(result));
	});
}

function set(key, ttl, data, next) {
	client.setex('postgres:' + key, ttl, JSON.stringify(data), function(err, result) {
		if (err || !result) return next(null);
		return next(result);
	});
}

function del(key, next) {
	client.del('postgres:' + key, function(err, result) {
		if (err || !result) return next(null);
		return next(result);
	});
}

///////////////////////////////////////

module.exports = {
	get: get,
	set: set,
	del: del
};