// // var postgres = require('./PostgresMiddleware');
// // module.exports = postgres

// const pg = require('pg');
// const { Client } = require('pg');
// const config = require('../../config');

// const client = new Client({
// 	connectionString: config.dbUrl,
// 	// statement_timeout: 120000
// });

// pg.types.setTypeParser(20, function (val) { // parse int8 as an integer
//     return val === null ? null : parseInt(val);
// });

// pg.types.setTypeParser(1700, function (val) { // parse numeric as a float
//     return val === null ? null : parseFloat(val);
// });

// client.connect();

// // Export the Postgres Client module
// module.exports = client;

// Import necessary modules
const { Client } = require('pg');
const pg = require('pg');
const config = require('../../config');

// Set type parsers for pg types
pg.types.setTypeParser(20, val => val === null ? null : parseInt(val)); // parse int8 as an integer
pg.types.setTypeParser(1700, val => val === null ? null : parseFloat(val)); // parse numeric as a float

// Initialize PostgreSQL client with connection string from config
const client = new Client({
    connectionString: config.dbUrl,
    // statement_timeout: 120000
});

// Function to connect to PostgreSQL with retry logic
async function connectWithRetry(retries = 5) {
    while (retries) {
        try {
            await client.connect();
            console.log('Connected to PostgreSQL database');
            break;
        } catch (err) {
            console.error('Error connecting to PostgreSQL:', err);
            retries -= 1;
            console.log(`Retries left: ${retries}`);
            if (!retries) throw err;
            await new Promise(res => setTimeout(res, 5000)); // wait for 5 seconds before retrying
        }
    }
}

// Connect to the database
connectWithRetry().catch(err => {
    console.error('Failed to connect to the database:', err);
    process.exit(1); // Exit process with failure
});

// Export the Postgres Client module
module.exports = client;
