const _ = require('lodash');
const axios = require('axios');
const H = require('../General/Helper');
const Market = require('../General/Market');

const Exchange = {};

/*
 * Crypto to Usd
 * @param amount | amount
 * @param coin | coin
 */
Exchange.cryptoToUsd = function(amount, coin, method2 = false, callback) {
	coin = _.upperCase(coin);
	let rate = Market.rate();
	var convertToUsd =  _.toNumber(amount) * _.toNumber(rate[coin]);
	return callback(convertToUsd)
}

/*
 * Crypto to Usd OLD METHOD
 * @param amount | amount
 * @param currency | currency
 */
Exchange.cryptoToUsd_OLD = function(amount, currency, method2 = false, callback) {
	currency = _.upperCase(currency);

	let api = "http://api.alternative.me/v2/ticker/?convert=USD";

	if(method2){
		var c = _.lowerCase(currency);
		api = `http://api.cryptapi.io/${c}/info/`;
	}

	axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
		url: api,
		method: 'GET'
	})
	.then(function(req){
		let response = req.data;

		var res = response.data;

		var i = 0, finded = null;

		if(method2)
			finded = res.prices;
		else
		{
	        for(i in res)
	        {
	            var item = res[i];
				if(item.symbol === currency){
					finded = item
				}
			}
		}

		if(finded === null){
			return callback(null)
		}
		
		var result;

		if(method2)
			result = finded['USD'];
		else 
			result = finded['quotes']['USD']['price'];
		
		var value = _.toNumber(amount) * _.toNumber(result);
		return callback(value)
		
	}).catch(function(e){
		console.log('cryptoToUsd method 2 start')
		return Exchange.cryptoToUsd(amount, currency, true, callback)
	});
}

/*
 * Usd to Crypto
 * @param amount | amount
 * @param currency | currency
 * full list => https://web-api.coinmarketcap.com/v1/cryptocurrency/listings/latest
 */
Exchange.usdToCrypto = function(amount, currency, callback) {
	amount = _.toNumber(amount);

	if(amount <= 0) 
		return callback(0);
	
	currency = _.upperCase(currency);

	let coin;

	if(currency === "BTC")
		coin = 1;
	
	else if(currency === "LTC")
		coin = 2;
	
	else if(currency === "ETH")
		coin = 1027;
	
	else if(currency === "BCH")
		coin = 1831;
	
	else if(currency === "USDT")
		coin = 825;
	
	else if(currency === "TRX")
		coin = 1958;
	
	else if(currency === "ADA")
		coin = 2010;
	
	else if(currency === "DOGE")
		coin = 74;
	
	else if(currency === "XRP")
		coin = 52;
	
	else if(currency === "BNB")
		coin = 1839;
	
	else if(currency === "USDP")
		coin = 3330;
	
	else if(currency === "MKR")
		coin = 1518;
	
	else if(currency === "TUSD")
		coin = 2563;
	
	else if(currency === "USDC")
		coin = 3408;
	
	else if(currency === "BUSD")
		coin = 4687;
	
	else if(currency === "INR")
		coin = 2790;


	const usd_id = 2781

	axios({  headers:{
    "Access-Control-Allow-Origin": "*",
    "Access-Control-Allow-Methods":"*"
  },
		url: `https://web-api.coinmarketcap.com/v1/tools/price-conversion?amount=${amount}&convert_id=${coin}&id=${usd_id}`,
		method: 'GET'
	})
	.then(function(req){
		let response = req.data;

		var res = response.data;

		var finded = res['quote'][coin]['price'];

		if(_.isUndefined(finded)){
			console.log('isUndefined finded')
			return callback(null)
		}

		var convered = H.CryptoSet(_.toNumber(finded));
		return callback(convered)

	}).catch(function(e){
		console.log('Error on Exchange: usdToCrypto', e)
	});
}

//Export Exchange Module
module.exports = Exchange;