const C = require('../General/Constant');
const Rule = require('./Rule');
const { encode, decode } = require('../General/Buffer');

/**
 * Slots Handler
 */
function Slots(client, io, id) {
    client.on(C.PLAT_SLOTS, (data) => {
        let { game, coin } = decode(data);
        if (!id) return;
        Rule.preparePlay(id, game, coin, client, (result) => {
            client.emit(C.PLAT_SLOTS, encode(result));
        })
    });
}

module.exports = Slots;