// auth-middleware.js
const _     = require('lodash');
const Token = require('./Token');

module.exports = function authMiddleware(req, res, next) {
  // 1) pull token out of headers (you can also support x-access-token, etc.)
  const authHeader = req.headers['authorization'];
  if (!authHeader) {
    return res.status(401).json({ error: 'No authorization header' });
  }

  // assume “Bearer <token>”
  const parts = authHeader.split(' ');
  const token = parts.length === 2 ? parts[1] : parts[0];

  // 2) verify against your Token table
  Token.getID(token, (uid, err) => {
    if (err || !uid) {
      return res.status(401).json({ error: 'Invalid or expired token' });
    }
    // 3) stash the user ID on req and call next()
    req.userId = uid;
    next();
  });
};
