const express = require('express');
const router = express.Router();
const AffiliateController = require('./affiliatecontroller');
const AffiliateUnlockController = require('./affiliateunlockcontroller');


// Get Referral Info for a User
router.get('/referral-info/:userId', async (req, res) => {
  try {
    const userId = req.params.userId;
    const referralInfo = await AffiliateController.getUserReferralInfo(userId);
    res.json(referralInfo);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Get Team Data by Referral Code
router.get('/team/:referralCode', async (req, res) => {
  try {
    const referralCode = req.params.referralCode;
    const teamData = await AffiliateController.getTeamData(referralCode);
    res.json(teamData);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Add Team Member
router.post('/team/add', async (req, res) => {
  const client = await db.connect();
  try {
    const { ownername, username, referralCode } = req.body;

    await client.query('BEGIN');

    // Pass client to the controller so it uses the same transaction
    const newTeamMember = await AffiliateController.addTeamMember(
      ownername,
      username,
      referralCode,
      client
    );

    await client.query('COMMIT');
    res.status(201).json(newTeamMember);
  } catch (error) {
    await client.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  } finally {
    client.release();
  }
});

// Record Affiliate Reward
router.post('/rewards/record', async (req, res) => {
  const client = await db.connect();
  try {
    const { ownerName, memberName, referalCode, amount, coin } = req.body;

    await client.query('BEGIN');

    // Pass the client to ensure all queries use the same transaction
    const reward = await AffiliateController.recordAffiliateReward(
      ownerName,
      memberName,
      referalCode,
      amount,
      coin,
      client
    );

    await client.query('COMMIT');
    res.status(201).json(reward);
  } catch (error) {
    await client.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  } finally {
    client.release();
  }
});

// Get User Rewards
router.get('/rewards/:referralCode', async (req, res) => {
  try {
    const referralCode = req.params.referralCode;
    const rewards = await AffiliateController.getUserRewards(referralCode);
    res.json(rewards);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Process wager update and check for unlockable rewards
router.post('/process-wager', async (req, res) => {
  const client = await db.connect();
  try {
    const { uid, membername, wagerAmount } = req.body;

    await client.query('BEGIN');

    // Use the same client inside the controller
    const result = await AffiliateUnlockController.processWagerAndUnlock(
      uid,
      membername,
      wagerAmount,
      client
    );

    await client.query('COMMIT');
    res.json(result);
  } catch (error) {
    await client.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  } finally {
    client.release();
  }
});

// Get unclaimed rewards for a user
router.get('/unclaimed-rewards/:uid', async (req, res) => {
  try {
    const uid = req.params.uid;
    const rewards = await AffiliateUnlockController.getUnclaimedRewards(uid);
    res.json(rewards);
  } catch (error) {
    res.status(500).json({ error: error.message });
  }
});

// Claim a specific reward
router.post('/claim-reward', async (req, res) => {
  const client = await db.connect();
  try {
    const { uid, rewardId } = req.body;

    await client.query('BEGIN');

    // Pass the client to ensure atomic DB operations
    const result = await AffiliateUnlockController.claimReward(uid, rewardId, client);

    await client.query('COMMIT');
    res.json(result);
  } catch (error) {
    await client.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  } finally {
    client.release();
  }
});
//claim all reward 
router.post('/claim-reward-all', async (req, res) => {
  const client = await db.connect();
  try {
    const { uid } = req.body;

    await client.query('BEGIN');

    const result = await AffiliateUnlockController.claimAllRewards(uid, client);

    await client.query('COMMIT');
    res.json(result);
  } catch (error) {
    await client.query('ROLLBACK');
    res.status(500).json({ error: error.message });
  } finally {
    client.release();
  }
});

module.exports = router;