// routes/transactionRoutes.js
const express = require('express');
const { 
  getTransactionHistory, 
  getUserTransactionHistory,
  getTransactionStats,
  getUserBetWinCount,
  getLuckySportsTransactionHistory 
} = require('./controller');

const router = express.Router();

// Route for all transactions with pagination and filters
router.get('/transactions', getTransactionHistory);

router.get('/transactions/luckysports', getLuckySportsTransactionHistory);

// Route for specific user transactions
router.get('/transactions/user/:userId', getUserTransactionHistory);

// Route for transaction statistics
router.get('/transactions/stats', getTransactionStats);

router.get('/user/:userId/bet-win-count', getUserBetWinCount);

module.exports = router;