const express = require('express');
const pg = require('../General/Model');
const { getVipLevelDetails } = require('./calculateVip');

const router = express.Router();



// Get bonus and claim history for all users
router.get('/api/admin/bonuses',  async (req, res) => {
  try {
    // Fetch bonus history
    const historyQuery = `
      SELECT bh.*, u.wager
      FROM bonus_history bh
      JOIN userwager u ON bh.userid = u.uid
      ORDER BY bh.created_at DESC
      LIMIT 100
    `;
    const historyResult = await pg.query(historyQuery);

    // Fetch user bonuses
    const bonusesQuery = `
      SELECT ub.userid, ub.dailybonus, ub.weeklybonus, ub.monthlybonus, u.wager
      FROM userbonus ub
      JOIN userwager u ON ub.userid = u.uid
    `;
    const bonusesResult = await pg.query(bonusesQuery);

    const users = bonusesResult.rows.map(user => {
      const vipDetails = getVipLevelDetails(
        user.wager ? parseFloat(user.wager.replace(/,/g, '')) : 0
      );
      return {
        userid: user.userid,
        vipLevel: vipDetails.previousVipLevel,
        bonuses: {
          daily: user.dailybonus,
          weekly: user.weeklybonus,
          monthly: user.monthlybonus
        }
      };
    });

    res.json({
      users,
      history: historyResult.rows.map(h => ({
        ...h,
        vipLevel: getVipLevelDetails(
          h.wager ? parseFloat(h.wager.replace(/,/g, '')) : 0
        ).previousVipLevel
      }))
    });
  } catch (error) {
    console.error('Error fetching admin bonus data:', error);
    res.status(500).json({ error: 'Internal server error' });
  }
});

module.exports = router;