const pg = require('../General/Model');
const crypto = require('crypto');


const generateUniqueCode = async (userid) => {
    let uniqueCode;
    let isUnique = false;
  
    while (!isUnique) {
      // Generate a hash based on userid and current timestamp
      const hash = crypto.createHash('sha256').update(`${userid}-${Date.now()}`).digest('hex');
      uniqueCode = hash.slice(0, 6).toUpperCase(); // Use first 6 characters, uppercase alphanumeric
  
      // Check if the code already exists in the table
      const query = `SELECT 1 FROM redeembonus WHERE code = $1`;
      const result = await pg.query(query, [uniqueCode]);
  
      if (result.rowCount === 0) {
        isUnique = true; // The code is unique
      }
    }
  
    return uniqueCode;
  };

const bonusController = {


    // redeemBonus : async (req, res) => {
    //     const { userid, code } = req.body;
      
    //     if (!userid || !code) {
    //       return res.status(400).json({ error: 'userid and code are required' });
    //     }
      
    //     try {
    //       // Step 1: Validate the code and its status
    //       const validateQuery = `
    //         SELECT amount, status FROM redeembonus WHERE userid = $1 AND code = $2
    //       `;
    //       const validateResult = await pg.query(validateQuery, [userid, code]);
      
    //       if (validateResult.rowCount === 0) {
    //         return res.status(404).json({ error: 'Code not found for the user' });
    //       }
      
    //       const { amount, status } = validateResult.rows[0];
      
    //       if (status !== 'active') {
    //         return res.status(400).json({ error: 'Code is not active' });
    //       }
      
    //       // Step 2: Update the `credits` table
    //       const updateCreditsQuery = `
    //         UPDATE credits
    //         SET bjb = bjb + $1
    //         WHERE uid = $2
    //       `;
    //       await pg.query(updateCreditsQuery, [amount, userid]);
      
    //       // Step 3: Mark the code as 'redeemed'
    //       const updateCodeStatusQuery = `
    //         UPDATE redeembonus
    //         SET status = 'redeemed', updatedat = NOW()
    //         WHERE userid = $1 AND code = $2
    //       `;
    //       await pg.query(updateCodeStatusQuery, [userid, code]);
      
    //       return res.status(200).json({ message: 'Bonus redeemed successfully', amount });
    //     } catch (err) {
    //       console.error(err);
    //       return res.status(500).json({ error: 'Failed to redeem bonus' });
    //     }
    //   },
redeemBonus : async (req, res) => {
  const { userid, code } = req.body;

  if (!userid || !code) {
    return res.status(400).json({ error: 'userid and code are required' });
  }

  try {
    await pg.query('BEGIN');
       console.log('Redeeming bonus for user:', userid, 'with code:', code);
    // Step 1: Validate the code and its status
    const validateQuery = `
      SELECT amount, status FROM redeembonus WHERE userid = $1 AND code = $2
    `;
    const validateResult = await pg.query(validateQuery, [userid, code]);
    console.log('Validation result:', validateResult.rows);
    if (validateResult.rowCount === 0) {
      await pg.query('ROLLBACK');
      return res.status(404).json({ error: 'Code not found for the user' });
    }

    const { amount, status } = validateResult.rows[0];

    if (status !== 'active') {
      await pg.query('ROLLBACK');
      return res.status(400).json({ error: 'Code is not active' });
    }

    // Step 2: Check if userbonus record exists
    const checkBonusQuery = `
      SELECT 1 FROM userbonus WHERE userid = $1
    `;
    const checkBonusResult = await pg.query(checkBonusQuery, [userid]);
    
    if (checkBonusResult.rowCount === 0) {
      await pg.query('ROLLBACK');
      return res.status(404).json({ error: 'No userbonus record found for the user' });
    }

    // Step 3: Update the userbonus table (specialbonus and totalbonus)
    const updateBonusQuery = `
      UPDATE userbonus
      SET specialbonus = specialbonus + $2,
          totalbonus = totalbonus + $2,
          updatedat = NOW()
      WHERE userid = $1
    `;
    await pg.query(updateBonusQuery, [userid, amount]);

    // Step 4: Update the credits table
    const updateCreditsQuery = `
      UPDATE credits
      SET bjb = COALESCE(bjb, 0) + $1
      WHERE uid = $2
    `;
    await pg.query(updateCreditsQuery, [amount, userid]);

    // Step 5: Mark the code as 'redeemed'
    const updateCodeStatusQuery = `
      UPDATE redeembonus
      SET status = 'redeemed', updatedat = NOW()
      WHERE userid = $1 AND code = $2
    `;
    await pg.query(updateCodeStatusQuery, [userid, code]);

    await pg.query('COMMIT');
    return res.status(200).json({ message: 'Bonus redeemed successfully', amount });
  } catch (err) {
    await pg.query('ROLLBACK');
    console.error('Error redeeming bonus:', err.stack);
    return res.status(500).json({ error: 'Failed to redeem bonus: ' + err.message });
  }
},
    createRedeemBonus :async (req, res) => {
        const { userid, amount } = req.body;
      
        if (!userid || !amount) {
          return res.status(400).json({ error: 'userid and amount are required' });
        }
      
        try {
          // Generate a unique code
          const code = await generateUniqueCode(userid);
      
          const query = `
            INSERT INTO redeembonus (userid, code, amount, status, createdat, updatedat)
            VALUES ($1, $2, $3, 'active', NOW(), NOW())
            RETURNING code
          `;
          const result = await pg.query(query, [userid, code, amount]);
      
          return res.status(201).json({ message: 'Redeem bonus created', code: result.rows[0].code });
        } catch (err) {
          console.error(err);
          return res.status(500).json({ error: 'Failed to create redeem bonus entry' });
        }
      },
 // Get all userbonus for admin
 getAllUserReedemBonus: async (req, res) => {
    try {
const result = await pg.query(`
    SELECT 
        userid,
        code,
        amount,
        status,
        createdat,
        updatedat
    FROM redeembonus
`);
        res.status(200).json(result.rows);
    } catch (err) {
        res.status(500).json({ error: 'Error fetching all user bonus data' });
    }
},
getUserReedemBonus: async (req, res) => {
    try {
        const { userid } = req.body;
        
        // Validate userid parameter
        if (!userid || userid === '' || userid === null || userid === undefined) {
            return res.status(400).json({ 
                error: 'User ID is required and cannot be empty' 
            });
        }
        
        // Convert to number if it's a string (additional safety)
        const userIdNum = parseInt(userid, 10);
        if (isNaN(userIdNum)) {
            return res.status(400).json({ 
                error: 'Invalid User ID format' 
            });
        }
        
       const result = await pg.query(`
    SELECT 
        userid,
        code,
        amount,
        status,
        createdat,
        updatedat
    FROM redeembonus 
    WHERE userid = $1
`, [userIdNum]);
        console.log(result);
        res.status(200).json(result.rows);
        
    } catch (err) {
        console.error('Error fetching user bonus data:', err);
        res.status(500).json({ error: 'Error fetching user bonus data' });
    }
},
getAllUserUserid: async (req, res) => {
    try {
        const result = await pg.query('SELECT id,name FROM users');
        res.status(200).json(result.rows);
    } catch (err) {
        res.status(500).json({ error: 'Error fetching all user  data' });
    }
},

    // Get userbonus for user or admin
    getUserBonus: async (req, res) => {
        const { userid, role } = req.body;
        try {
           const query = role === 'admin' 
    ? `SELECT 
        userid,
        name,
        totalbonus,
        vipbonus,
        specialbonus,
        generalbonus,
        createdat,
        updatedat,
        joiningbonus,
        dailybonus,
        weeklybonus,
        monthlybonus,
        last_daily_reset,
        last_weekly_reset,
        last_monthly_reset,
        rakebonus,
        actualdailybonus,
        actualweeklybonus,
        actualmonthlybonus
       FROM userbonus`
    : `SELECT 
        userid,
        name,
        totalbonus,
        vipbonus,
        specialbonus,
        generalbonus,
        createdat,
        updatedat,
        joiningbonus,
        dailybonus,
        weeklybonus,
        monthlybonus,
        last_daily_reset,
        last_weekly_reset,
        last_monthly_reset,
        rakebonus,
        actualdailybonus,
        actualweeklybonus,
        actualmonthlybonus
       FROM userbonus 
       WHERE userid = $1`;
            const result = await pg.query(query, role === 'admin' ? [] : [userid]);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching user bonus data' });
        }
    },

    // Get bonusgame for user or admin
    getUserBonusGame: async (req, res) => {
        const { userid, role } = req.body;
        try {
          const query = role === 'admin'
    ? `SELECT 
        userid,
        luckyspin,
        dailybonus,
        weeklybonus,
        monthlybonus,
        depositbonus,
        rollcompetitionbonus,
        createdat,
        updatedat,
        rakebackbonus
       FROM bonusgame`
    : `SELECT 
        userid,
        luckyspin,
        dailybonus,
        weeklybonus,
        monthlybonus,
        depositbonus,
        rollcompetitionbonus,
        createdat,
        updatedat,
        rakebackbonus
       FROM bonusgame 
       WHERE userid = $1`;
            const result = await pg.query(query, role === 'admin' ? [] : [userid]);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching bonus game data' });
        }
    },

    // Get bonushistory for user or admin
    getUserBonusHistory: async (req, res) => {
        const { userid, role } = req.body;
        try {
        const query = role === 'admin'
    ? `SELECT 
        userid,
        event,
        amount,
        createdat,
        updatedat
       FROM bonushistory`
    : `SELECT 
        userid,
        event,
        amount,
        createdat,
        updatedat
       FROM bonushistory 
       WHERE userid = $1`;
            const result = await pg.query(query, role === 'admin' ? [] : [userid]);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching bonus history data' });
        }
    },

    // Create userbonus
    createUserBonus: async (req, res) => {
        const { userid, name, totalbonus, vipbonus, specialbonus, generalbonus } = req.body;
        try {
            const result = await pg.query(
                `INSERT INTO userbonus (userid, name, totalbonus, vipbonus, specialbonus, generalbonus, createdat, updatedat) 
                VALUES ($1, $2, $3, $4, $5, $6, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP) RETURNING *`,
                [userid, name, totalbonus, vipbonus, specialbonus, generalbonus]
            );
            res.status(201).json(result.rows[0]);
        } catch (err) {
            res.status(500).json({ error: 'Error creating user bonus' });
        }
    },

    // Create bonusgame
    createUserBonusGame: async (req, res) => {
        const { userid, luckyspin, dailybonus, weeklybonus, monthlybonus, depositbonus, rollcompetitionbonus } = req.body;
        try {
            const result = await pg.query(
                `INSERT INTO bonusgame (userid, luckyspin, dailybonus, weeklybonus, monthlybonus, depositbonus, rollcompetitionbonus, createdat, updatedat) 
                VALUES ($1, $2, $3, $4, $5, $6, $7, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP) RETURNING *`,
                [userid, luckyspin, dailybonus, weeklybonus, monthlybonus, depositbonus, rollcompetitionbonus]
            );
            res.status(201).json(result.rows[0]);
        } catch (err) {
            res.status(500).json({ error: 'Error creating bonus game' });
        }
    },

    // Create bonushistory
    createUserBonusHistory: async (req, res) => {
        const { userid, event, amount } = req.body;
        try {
            const result = await pg.query(
                `INSERT INTO bonushistory (userid, event, amount, createdat, updatedat) 
                VALUES ($1, $2, $3, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP) RETURNING *`,
                [userid, event, amount]
            );
            res.status(201).json(result.rows[0]);
        } catch (err) {
            res.status(500).json({ error: 'Error creating bonus history' });
        }
    },

   // Update userbonus with accumulated values
   updateUserBonus: async (req, res) => {
    const { userid, role, name, totalbonus, vipbonus, specialbonus, generalbonus } = req.body;
    console.log('Request body:', req.body);
    
    const userIdToUpdate = role === 'admin' ? userid : userid;
    console.log('User ID to update:', userIdToUpdate);

    try {
        // Begin transaction
        console.log('Starting transaction...');
        await pg.query('BEGIN');

        // Update userbonus table with accumulated values
        console.log('Updating userbonus table with values:', {
            name,
            totalbonus,
            vipbonus,
            specialbonus,
            generalbonus
        });

        const bonusResult = await pg.query(
            `UPDATE userbonus SET name = $1,  vipbonus = COALESCE(vipbonus, 0) + $2, specialbonus = COALESCE(specialbonus, 0) + $3, generalbonus = COALESCE(generalbonus, 0) + $4, updatedat = CURRENT_TIMESTAMP WHERE userid = $5 RETURNING *`,
            [name,vipbonus, specialbonus, generalbonus, userIdToUpdate]
        );
        console.log('Userbonus update result:', bonusResult.rows[0]);

        // Calculate total bonus amount to add to bjb
        const totalBonusAmount =  (vipbonus || 0) + (specialbonus || 0) + (generalbonus || 0);
        console.log('Total bonus amount calculated:', totalBonusAmount);

        // Update credits table bjb value
        if (totalBonusAmount > 0) {
            console.log('Updating credits table with bjb amount:', totalBonusAmount);
            await pg.query(
                `UPDATE credits SET bjb = COALESCE(bjb, 0) + $1 WHERE uid = $2`,
                [totalBonusAmount, userIdToUpdate]
            );
        }

        await pg.query('COMMIT');
        console.log('Transaction committed successfully');
        res.status(200).json(bonusResult.rows[0]);

    } catch (err) {
        console.error('Error in updateUserBonus:', err);
        await pg.query('ROLLBACK');
        console.log('Transaction rolled back due to error');
        res.status(500).json({ error: 'Error updating user bonus' });
    }
},

// Update bonusgame with accumulated values
 updateUserBonusGame : async (req, res) => {
    const { userid, role, luckyspin, dailybonus, weeklybonus, monthlybonus, 
            depositbonus, rollcompetitionbonus } = req.body;
    const userIdToUpdate = role === 'admin' ? req.body.target_userid : userid;
    try {
        await pg.query('BEGIN');

        // Update bonusgame table with accumulated values
        const gameResult = await pg.query(
            `UPDATE bonusgame 
             SET luckyspin = COALESCE(luckyspin, 0) + $1,
                 dailybonus = COALESCE(dailybonus, 0) + $2,
                 weeklybonus = COALESCE(weeklybonus, 0) + $3,
                 monthlybonus = COALESCE(monthlybonus, 0) + $4,
                 depositbonus = COALESCE(depositbonus, 0) + $5,
                 rollcompetitionbonus = COALESCE(rollcompetitionbonus, 0) + $6,
                 updatedat = CURRENT_TIMESTAMP
             WHERE userid = $7 
             RETURNING *`,
            [luckyspin, dailybonus, weeklybonus, monthlybonus, 
             depositbonus, rollcompetitionbonus, userIdToUpdate]
        );

        // Calculate total bonus amount to add to bjb
        const totalBonusAmount = (luckyspin || 0) + (dailybonus || 0) + 
                               (weeklybonus || 0) + (monthlybonus || 0) + 
                               (depositbonus || 0) + (rollcompetitionbonus || 0);

        // Update credits table bjb value
        if (totalBonusAmount > 0) {
            await pg.query(
                `UPDATE credits 
                 SET bjb = COALESCE(bjb, 0) + $1 
                 WHERE uid = $2`,
                [totalBonusAmount, userIdToUpdate]
            );
        }

        await pg.query('COMMIT');
        res.status(200).json(gameResult.rows[0]);
    } catch (err) {
        await pg.query('ROLLBACK');
        res.status(500).json({ error: 'Error updating bonus game' });
    }
},

    // Update bonushistory
    updateUserBonusHistory: async (req, res) => {
        const { userid, role, event, amount } = req.body;
        const userIdToUpdate = role === 'admin' ? req.body.target_userid : userid;
        try {
            const result = await pg.query(
                `UPDATE bonushistory 
                SET event = $1, amount = $2, updatedat = CURRENT_TIMESTAMP
                WHERE userid = $3 RETURNING *`,
                [event, amount, userIdToUpdate]
            );
            res.status(200).json(result.rows[0]);
        } catch (err) {
            res.status(500).json({ error: 'Error updating bonus history' });
        }
    },

    // Delete userbonus
   deleteUserBonus: async (req, res) => {
    const { userid, role } = req.body;
    const userIdToDelete = role === 'admin' ? req.body.target_userid : userid;
    const client = await pg.connect();

    try {
        await client.query('BEGIN');

        const result = await client.query(
            `DELETE FROM userbonus WHERE userid = $1 RETURNING *`,
            [userIdToDelete]
        );

        // You can add more related deletes/updates here if needed

        await client.query('COMMIT');
        res.status(200).json({ message: 'User bonus deleted successfully' });
    } catch (err) {
        await client.query('ROLLBACK');
        res.status(500).json({ error: 'Error deleting user bonus' });
    } finally {
        client.release();
    }
},


    // Delete bonusgame
    deleteUserBonusGame: async (req, res) => {
        const { userid, role } = req.body;
        const userIdToDelete = role === 'admin' ? req.body.target_userid : userid;
        try {
            const result = await pg.query(
                `DELETE FROM bonusgame WHERE userid = $1 RETURNING *`,
                [userIdToDelete]
            );
            res.status(200).json({ message: 'Bonus game deleted successfully' });
        } catch (err) {
            res.status(500).json({ error: 'Error deleting bonus game' });
        }
    },

    // Delete bonushistory
    deleteUserBonusHistory: async (req, res) => {
        const { userid, role } = req.body;
        const userIdToDelete = role === 'admin' ? req.body.target_userid : userid;
        try {
            const result = await pg.query(
                `DELETE FROM bonushistory WHERE userid = $1 RETURNING *`,
                [userIdToDelete]
            );
            res.status(200).json({ message: 'Bonus history deleted successfully' });
        } catch (err) {
            res.status(500).json({ error: 'Error deleting bonus history' });
        }
    },

    // Get all userbonus for admin
    getAllUserBonus: async (req, res) => {
        try {
         const result = await pg.query(`
    SELECT 
        userid,
        name,
        totalbonus,
        vipbonus,
        specialbonus,
        generalbonus,
        createdat,
        updatedat,
        joiningbonus,
        dailybonus,
        weeklybonus,
        monthlybonus,
        last_daily_reset,
        last_weekly_reset,
        last_monthly_reset,
        rakebonus,
        actualdailybonus,
        actualweeklybonus,
        actualmonthlybonus
    FROM userbonus
`);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching all user bonus data' });
        }
    },

    // Get all bonusgame for admin
    getAllBonusGame: async (req, res) => {
        try {
          const result = await pg.query(`
    SELECT 
        userid,
        luckyspin,
        dailybonus,
        weeklybonus,
        monthlybonus,
        depositbonus,
        rollcompetitionbonus,
        createdat,
        updatedat,
        rakebackbonus
    FROM bonusgame
`);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching all bonus game data' });
        }
    },

    // Get all bonushistory for admin
    getAllBonusHistory: async (req, res) => {
        try {
        const result = await pg.query(`
    SELECT 
        userid,
        event,
        amount,
        createdat,
        updatedat
    FROM bonushistory
`);
            res.status(200).json(result.rows);
        } catch (err) {
            res.status(500).json({ error: 'Error fetching all bonus history data' });
        }
    }
};

module.exports = bonusController;
