const winston = require('winston');

// Create a Winston logger
const logger = winston.createLogger({
  level: 'info', // Log info and above (info, warn, error)
  format: winston.format.combine(
    winston.format.timestamp({ format: 'YYYY-MM-DD HH:mm:ss' }), // Add timestamp
    winston.format.printf(({ timestamp, level, message }) => {
      return `[${timestamp}] ${level.toUpperCase()}: ${message}`; // Format: [YYYY-MM-DD HH:mm:ss] LEVEL: message
    })
  ),
  transports: [
    // Write to console
    new winston.transports.Console(),
    // Write to a text file with rotation
    new winston.transports.File({
      filename: 'logs/bonus-cron.txt', // Output file
      maxsize: 10 * 1024 * 1024, // 10MB max per file
      maxFiles: 5, // Keep last 5 files
      tailable: true // Rotate files
    })
  ]
});

// Export the logger
module.exports = logger;