// manual-trigger.js
const { manualTriggerBonusCalculation } = require('./bonusCron');

async function triggerBonusCalculation() {
  console.log('Manually triggering bonus calculation...');
  try {
    const result = await manualTriggerBonusCalculation();
    console.log('Manual trigger completed with result:', result ? 'Success' : 'Failed');
    return result;
  } catch (error) {
    console.error('Error during manual trigger:', error);
    return false;
  }
}

// If running directly from command line
if (require.main === module) {
  triggerBonusCalculation()
    .then(result => {
      console.log(`Process completed: ${result ? 'Successfully' : 'With errors'}`);
      process.exit(result ? 0 : 1);
    })
    .catch(err => {
      console.error('Unexpected error:', err);
      process.exit(1);
    });
}

// Export for use in other files
module.exports = triggerBonusCalculation;