const { Router } = require('express');
const bonusController = require('./bonusController');
const { checkRole } = require('./checkRole');

const router = Router();

// User-specific and shared routes (accessible by both users and admins)
router.post('/userbonus', checkRole('user', 'admin'), bonusController.getUserBonus);
router.post('/bonusgame', checkRole('user', 'admin'), bonusController.getUserBonusGame);
router.post('/bonushistory', checkRole('user', 'admin'), bonusController.getUserBonusHistory);
router.post('/createuserbonus', checkRole('user', 'admin'), bonusController.createUserBonus);
router.post('/createbonusgame', checkRole('user', 'admin'), bonusController.createUserBonusGame);
router.post('/createbonushistory', checkRole('user', 'admin'), bonusController.createUserBonusHistory);
router.put('/userbonus', checkRole('user', 'admin'), bonusController.updateUserBonus);
router.put('/bonusgame', checkRole('user', 'admin'), bonusController.updateUserBonusGame);
router.put('/bonushistory', checkRole('user', 'admin'), bonusController.updateUserBonusHistory);
router.delete('/userbonus', checkRole('user', 'admin'), bonusController.deleteUserBonus);
router.delete('/bonusgame', checkRole('user', 'admin'), bonusController.deleteUserBonusGame);
router.delete('/bonushistory', checkRole('user', 'admin'), bonusController.deleteUserBonusHistory);
// Route to redeem a bonus
router.post('/redeem-bonus/redeem',checkRole('user', 'admin'), bonusController.redeemBonus);

router.get('/redeem-bonus',checkRole('admin'), bonusController.getAllUserReedemBonus);
router.post('/user',checkRole('user'), bonusController.getUserReedemBonus);

router.get('/users',checkRole('admin'), bonusController.getAllUserUserid);

// Admin-specific routes
router.get('/admin/userbonus', checkRole('admin'), bonusController.getAllUserBonus);
router.get('/admin/bonusgame', checkRole('admin'), bonusController.getAllBonusGame);
router.get('/admin/bonushistory', checkRole('admin'), bonusController.getAllBonusHistory);
// Route to create a redeem bonus entry
router.post('/redeem-bonus/create',checkRole('admin'), bonusController.createRedeemBonus);

module.exports = router;
