// src/routes/clubRoutes.js
const express = require('express');
const router = express.Router();
const clubController = require('./membershipController');
const { upload } = require('./fileupload');


router.post('/create', upload.single('profilePicture'), clubController.createClub);
router.put('/update', upload.single('profilePicture'), clubController.updateClub);
router.delete('/:clubId/delete', clubController.deleteClub);
router.get('/:tableName/fetch', clubController.fetchData);
router.post('/join', clubController.joinClub);
router.post('/change-role', clubController.changeUserRole);
router.get('/profile/:clubId', clubController.getClubProfilePicture);
router.get('/userprofile/:userId', clubController.getClubProfile);
router.get('/:clubId/hierarchy', clubController.getClubHierarchy);
router.get('/user-affiliations/:userId', clubController.getUserClubAffiliations);
                                

// Admin Configuration Routes
router.put('/earnings-config', clubController.updateEarningsConfiguration);

module.exports = router;

