// templates.service.js
class EmailTemplateService {
    static getTemplate(type, data) {
        const templates = {
            otp: `
                <!DOCTYPE html>
                <html>
                <head>
                    <style>
                        body { margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
                        .container { max-width: 600px; margin: 0 auto; background: #f8f9fa; }
                        .header { background: linear-gradient(135deg, #6366F1 0%, #4F46E5 100%); padding: 30px; text-align: center; }
                        .header h1 { color: white; margin: 0; font-size: 24px; }
                        .content { padding: 40px 20px; background: white; border-radius: 8px; margin: 20px; }
                        .otp-box { 
                            background: #f8fafc;
                            border: 1px dashed #cbd5e1;
                            border-radius: 8px;
                            padding: 20px;
                            text-align: center;
                            margin: 20px 0;
                        }
                        .otp-code {
                            font-size: 32px;
                            letter-spacing: 8px;
                            color: #4F46E5;
                            font-weight: bold;
                        }
                        .timer { color: #ef4444; font-size: 14px; margin-top: 10px; }
                        .footer { text-align: center; padding: 20px; color: #64748b; font-size: 12px; }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <div class="header">
                            <h1>${data.title}</h1>
                        </div>
                        <div class="content">
                            <p>Hello,</p>
                            <p>${data.message}</p>
                            <div class="otp-box">
                                <div class="otp-code">${data.otp}</div>
                                <div class="timer">Valid for 2 minutes only</div>
                            </div>
                            <p>If you didn't request this code, please ignore this email.</p>
                        </div>
                        <div class="footer">
                            <p>Sent at ${new Date().toLocaleString()}</p>
                            <p>© ${new Date().getFullYear()} smartbet36.com. All rights reserved.</p>
                        </div>
                    </div>
                </body>
                </html>
            `,
            general: `
                <!DOCTYPE html>
                <html>
                <head>
                    <style>
                        body { margin: 0; padding: 0; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
                        .container { max-width: 600px; margin: 0 auto; background: #f8f9fa; }
                        .header { background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%); padding: 30px; text-align: center; }
                        .header h1 { color: white; margin: 0; font-size: 24px; }
                        .content { padding: 40px 20px; background: white; border-radius: 8px; margin: 20px; }
                        .message { line-height: 1.6; color: #1f2937; }
                        .cta-button {
                            display: inline-block;
                            padding: 12px 24px;
                            background: #3B82F6;
                            color: white;
                            text-decoration: none;
                            border-radius: 6px;
                            margin: 20px 0;
                        }
                        .footer { text-align: center; padding: 20px; color: #64748b; font-size: 12px; }
                    </style>
                </head>
                <body>
                    <div class="container">
                        <div class="header">
                            <h1>${data.title}</h1>
                        </div>
                        <div class="content">
                            <div class="message">
                                ${data.content}
                            </div>
                            ${data.ctaLink ? `
                                <a href="${data.ctaLink}" class="cta-button">${data.ctaText || 'Learn More'}</a>
                            ` : ''}
                        </div>
                        <div class="footer">
                            <p>Sent at ${new Date().toLocaleString()}</p>
                            <p>© ${new Date().getFullYear()} smartbet36.com. All rights reserved.</p>
                        </div>
                    </div>
                </body>
                </html>
            `
        };

        return templates[type] || templates.general;
    }
}

module.exports = EmailTemplateService;