/* =============================================================
   GIS Slotegrator routes – thin layer that just wires endpoints
   to controller methods defined in gisController.js
   ============================================================= */

const express = require('express');
const ctr     = require('./controller');
const router  = express.Router();

/* ───── Game catalogue & lobby ─────────────────────────────── */
router.get ('/games',             ctr.getGames);
router.get ('/game-tags',         ctr.getGameTags);
router.get ('/games/lobby',       ctr.getGameLobby);
router.post('/games/init',        ctr.initGame);
router.post('/games/init-demo',   ctr.initDemoGame);
router.get ('/games/provider',    ctr.getGamesByProvider);
router.get ('/providers',         ctr.getProviders);

/* ───── Callback (transactions) ─────────────────────────────── */
router.post('/callback/transactions', ctr.handleTransaction);

/* ───── Limits & jackpots ───────────────────────────────────── */
router.get('/limits',             ctr.getLimits);
router.get('/limits/freespin',    ctr.getFreespinLimits);
router.get('/jackpots',           ctr.getJackpots);

/* ───── Freespins ───────────────────────────────────────────── */
router.get ('/freespins/bets',    ctr.getFreespinBets);
router.post('/freespins/set',     ctr.setFreespin);
router.get ('/freespins/get',     ctr.getFreespin);
router.post('/freespins/cancel',  ctr.cancelFreespin);

/* ───── Freevouchers ────────────────────────────────────────── */
router.post('/freevouchers/set',    ctr.setFreevoucher);
router.get ('/freevouchers/get',    ctr.getFreevoucher);
router.post('/freevouchers/cancel', ctr.cancelFreevoucher);

/* ───── Self-validate & sync ────────────────────────────────── */
router.post('/self-validate',     ctr.selfValidate);
router.get ('/sync',              ctr.syncGames);

/* ───── GIS local DB search endpoints ───────────────────────── */
router.get('/providersgis',                ctr.getProvidersgis);
router.get('/gamesgis',                    ctr.getGamesgis);
router.get('/gamesgis/provider/:provider', ctr.getGamesByProvidergis);
router.get('/gamesgis/stats',              ctr.getGameStats);

module.exports = router;
