// routes/swapRoutes.js

const express = require('express');
const router = express.Router();
const swapController = require('./controller');

// Get user's available balances
router.get('/balances/:uid', swapController.getUserBalances);

// Get swap estimate
router.get('/estimate', swapController.getSwapEstimate);

// Perform swap
router.post('/swap', swapController.swapCurrency);

// Get all swap history
router.get('/history', swapController.getAllSwapHistory);

// Get user's swap history
router.get('/history/:uid', swapController.getUserSwapHistory);

module.exports = router;