const express = require('express');
const router = express.Router();
const GameController = require('./controller');


// 1. Get Game Launch URL (SEAMLESS)
router.post('/game/launch',  async (req, res) => {
    await GameController.getGameLaunchURL(req, res);
});

// 2. Bet Callback (External API Callback)
router.post('/game/bet-callback', async (req, res) => {
    await GameController.processBetCallback(req, res);
});

// 3. Game Transfer (Deposit/Withdrawal)
router.post('/game/transfer',  async (req, res) => {
    await GameController.processGameTransfer(req, res);
});

// 4. Get Transaction Records
router.post('/game/transactions',  async (req, res) => {
    await GameController.getTransactionRecords(req, res);
});

// Get active games with pagination
router.get(
    '/games',
    GameController.constructor.getActiveGamesValidationRules(),
    GameController.getActiveGames
);

// Search games API endpoint
router.get(
    '/games/search',
    GameController.constructor.getSearchValidationRules(),
    GameController.searchGames
);

module.exports = router;