const  { getUserReports, getAllUsersReports,exportUsersReports } = require('./controller');
const express = require('express');
const router = express.Router();





/**
 * @route GET /api/reports/user/:userId
 * @desc Get reports for a specific user
 * @access Private
 */
router.get('/user/:userId', getUserReports);

/**
 * @route GET /api/reports/users
 * @desc Get reports for all users with pagination and search
 * @access Private
 */
router.get('/users', getAllUsersReports);

/**
 * @route GET /api/reports/export
 * @desc Export all users reports as CSV with optional search
 * @access Private
 */
router.get('/export', exportUsersReports);

module.exports = router;