const pg = require("../../General/Model");

/** descendant staff-ids + self; superadmin also gets NULL (orphans) */
async function permittedIds(staffId, level) {
  const { rows } = await pg.query(
    `SELECT descendant_id FROM staff_hierarchy WHERE ancestor_id=$1`,
    [staffId]
  );
  const ids = rows.map(r => r.descendant_id);
  ids.push(staffId);
  if (level === 0) ids.push(null);
  return ids;
}

/** flat list of users in that hierarchy */
// async function listUsersTree(staffId, level) {
//   const ids = await permittedIds(staffId, level);
//   const { rows } = await pg.query(
//     `SELECT id,name,email,parent_staff_id
//        FROM users
//       WHERE parent_staff_id = ANY($1)
//          OR ($2 = 0 AND parent_staff_id IS NULL)
//       ORDER BY parent_staff_id NULLS FIRST, id`,
//     [ids, level]
//   );
//   return rows;
// }
async function listUsersTree(staffId, level) {
  const ids = await permittedIds(staffId, level);   // keep numeric
  console.log('level',level);
  console.log("listUsersTree → staff %s  level(%s) = %o",
            staffId, typeof level, level);

  const { rows } = await pg.query(
    `SELECT id,name,email,parent_staff_id
       FROM users
      WHERE parent_staff_id = ANY($1)
         OR ($2::int = 0 AND parent_staff_id IS NULL)
      ORDER BY parent_staff_id NULLS FIRST, id`,
    [ids, level]
  );
  return rows;
}

module.exports = { permittedIds, listUsersTree };
