const pg = require('../../General/Model');
function buildUpdate(obj, start=1){
  const k=Object.keys(obj);
  return { clause:k.map((c,i)=>`"${c}"=$${i+start}`).join(','),
           values:k.map(c=>obj[c]) };
}
module.exports={
  async get() {
    const { rows } = await pg.query(`
        SELECT 
            registerbonus,
            createdat,
            updatedat,
            sports,
            affiliatebonus,
            comissionpercent,
            inr,
            mvr,
            aed,
            pkr,
            cryptocoin,
            bjb,
            casino,
            lotto,
            vipclub,
            clubmembership,
            bonus,
            affiliate,
            crash,
            originals,
            livegames,
            slotsgames,
            alllivegames,
            allslotsgames,
            lotterygames,
            indiangames,
            cards,
            jilli,
            bdt,
            clubrake,
            instantgames,
            btc,
            eth,
            ltc,
            bch,
            usdt,
            trx,
            doge,
            ada,
            xrp,
            bnb,
            usdp,
            nexo,
            mkr,
            tusd,
            usdc,
            busd,
            nc,
            npr,
            shib,
            matic,
            sc,
            spribe,
            evolution,
            pragmaticslots,
            pragmaticlive,
            ideal,
            microgaming,
            pgsoft,
            hacksawgaming,
            jili,
            netent,
            esports,
            provablyfair
        FROM siteconfig 
        LIMIT 1
    `);
    return rows[0];
},
  async update(f){ const {clause,values}=buildUpdate(f);
    const {rows}=await pg.query(`UPDATE siteconfig SET ${clause},updatedat=now() RETURNING *`,values);
    return rows[0]; }
};
module.exports.buildUpdate=buildUpdate;
