const ROOM = { g: 'room:global', u: id => `room:user:${id}` };
const siteModel = require('../model/siteconfigmodels');
const userModel = require('../model/userconfigmodel');


module.exports = io => {
  io.on('connection', async socket => {
    /* everyone joins the global room right away */
    socket.join(ROOM.g);
    socket.emit('siteConfigUpdated', await siteModel.get());

    /* ① wait for the client to tell us its uid */
   socket.on("identify", async raw => {
  const uid = Number(raw);
  console.log('identity uid',uid);
  if (!uid || isNaN(uid)) {
    socket.emit("identify-error", "uid must be a number");
    return;
  }
  socket.userid = uid;
  socket.join(ROOM.u(uid));

  const cfg = await userModel.get(uid);
  socket.emit("userConfigUpdated", cfg);

  /* optional: acknowledge */
  const ack = Array.prototype.slice.call(arguments)[1];
  if (typeof ack === "function") ack({ ok: true });
});


    /* optional: allow re-subscribing to another uid (admin preview) */
    socket.on('subscribeUserConfig', id => socket.join(ROOM.u(id)));
  });
};
