const { Queue } = require('bullmq');
const IORedis  = require('ioredis');

const connection = new IORedis({
  host: process.env.REDIS_HOST||'127.0.0.1',
  port: process.env.REDIS_PORT||6379,
});

module.exports = new Queue('sports', {
  connection,
  defaultJobOptions: {
    attempts: 3,
    backoff: { type: 'exponential', delay: 2000 },
    removeOnComplete: 5000,
    removeOnFail:     1000,
  },
});
