const db = require('../General/Model');

const filterSeriesData = async (seriesData, gameId) => {
    try {
      // Convert gameId to string to ensure consistent comparison
      const gameIdStr = gameId.toString();
  
      // Check if the game is enabled in sports_config
      const enabledGameQuery = await db.query(
        'SELECT enabled FROM sports_config WHERE game_id = $1',
        [gameIdStr]
      );
  
      // If no game found or game is not enabled, return empty array
      if (enabledGameQuery.rows.length === 0 || !enabledGameQuery.rows[0].enabled) {
        console.log(`Game ID ${gameIdStr} is not enabled or not found`);
        return "Game not found or not enabled for you";
      }
  
      // If game is enabled, return the original series data
      return seriesData;
    } catch (error) {
      console.error('Series filtering error:', error);
      throw new Error('Error filtering series data');
    }
  };
  
  module.exports = { filterSeriesData };