const axios = require('axios');
const { filterEnabledGames } = require('./gamefilter');
const db = require('../General/Model');

console.log('Loading sportsapiinplaycontroller...');
const getInplayData = async (req, res) => {
    try {
      console.log('Inplay Data Request Received:');
      console.log('Request Body:', req.body);
      console.log('Environment Variables:');
      console.log('RAPIDAPI_KEY:', process.env.RAPIDAPI_KEY ? 'Set' : 'Not Set');
      console.log('RAPIDAPI_HOST:', process.env.RAPIDAPI_HOST ? 'Set' : 'Not Set');
      console.log('SCORESWIFT_KEY:', process.env.SCORESWIFT_KEY ? 'Set' : 'Not Set');
 
      // Make request to external API
      const response = await axios.get('http://89.116.20.218:8085/api/inplay', {
        headers: {
          'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
          'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
          'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
        }
      });
 
      console.log('API Response:');
      console.log('Total Items:', response.data.length);
      console.log('First Few Items:', response.data.slice(0, 3));
 
      // If a specific gameId is provided
      if (req.body.gameId) {
        console.log('Filtering for specific gameId:', req.body.gameId);
        const filteredData = response.data.filter(
          item => item.id === req.body.gameId.toString()
        );
 
        console.log('Filtered Data:', filteredData);
 
        if (filteredData.length === 0) {
          console.warn(`No data found for gameId: ${req.body.gameId}`);
          return res.status(404).json({
            error: 'No data found for the specified game',
            requestedGameId: req.body.gameId
          });
        }
 
        return res.json(filteredData[0]);
      }
 
      // If no gameId, filter and return only enabled games
      const filteredGames = await filterEnabledGames(response.data);
      
      console.log('Enabled Games:', filteredGames);
 
      res.json(filteredGames);
    } catch (error) {
      console.error('Inplay data fetch error:', error);
 
      // More detailed error logging
      if (error.response) {
        // The request was made and the server responded with a status code
        console.error('Error Response Data:', error.response.data);
        console.error('Error Response Status:', error.response.status);
        console.error('Error Response Headers:', error.response.headers);
      } else if (error.request) {
        // The request was made but no response was received
        console.error('No response received:', error.request);
      } else {
        // Something happened in setting up the request
        console.error('Error Message:', error.message);
      }
 
      res.status(500).json({
        error: 'Error fetching inplay data',
        details: error.message
      });
    }
 };

const getAllEnabledGames = async (req, res) => {
  try {
    // Make request to external API
    const response = await axios.get('http://89.116.20.218:8085/api/inplay', {
        headers: {
            'x-rapidapi-key': process.env.RAPIDAPI_KEY??'eNp57Jb7yHgI26S8Yw4u_v31',
            'x-rapidapi-host': process.env.RAPIDAPI_HOST??'betfair14.p.rapidapi.com',
            'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY??'eNp57Jb7yHgI26S8Yw4u_v31'
          }
    });

    // Filter only enabled games
    const filteredGames = await filterEnabledGames(response.data);

    res.json(filteredGames);
  } catch (error) {
    console.error('All games fetch error:', error);
    res.status(500).json({ 
      error: 'Error fetching games' 
    });
  }
};
const getInPlayByGameId = async (req, res) => {
  try {
    const { gameId } = req.params;
    
    // Validate game ID parameter
    if (!gameId) {
      return res.status(400).json({ 
        error: 'Game ID parameter is required' 
      });
    }

    // Check if the game ID is enabled in the database
    const gameConfigQuery = await db.query(
  `SELECT
     id,
     game_id,
     game_name,
     enabled,
     created_at,
     updated_at
   FROM sports_config
   WHERE game_id = $1
     AND enabled = true`,
  [gameId]
);


    if (gameConfigQuery.rows.length === 0) {
      return res.status(404).json({ 
        error: 'Game not found or not enabled',
        gameId: gameId
      });
    }

    const gameConfig = gameConfigQuery.rows[0];

    // Make request to external API
    const response = await axios.get('http://89.116.20.218:8085/api/inplay', {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Filter games for the specific game ID
    const filteredGames = response.data.filter(game => {
      return game.id.toString() === gameId.toString();
    });

    // Return the filtered games with config info
    res.json({
      gameConfig: {
        id: gameConfig.id,
        gameId: gameConfig.game_id,
        gameName: gameConfig.game_name,
        enabled: gameConfig.enabled
      },
      games: filteredGames,
      totalGames: filteredGames.length
    });

  } catch (error) {
    console.error('Game ID fetch error:', error);
    res.status(500).json({ 
      error: 'Error fetching games for game ID',
      gameId: req.params.gameId 
    });
  }
};

module.exports = { 
  getInplayData,
  getAllEnabledGames,
  getInPlayByGameId
};
// console.log('Available functions:', Object.keys(module.exports));