const axios = require('axios');

// Function to get Market IDs V1 (by Event ID)
const getMarketIdsV1 = async (req, res) => {
  try {
    const { eventid } = req.query;

    // Validate event ID is provided
    if (!eventid) {
      return res.status(400).json({
        error: 'Event ID is required'
      });
    }

    // Make request to external API with event ID
    const response = await axios.get(`http://89.116.20.218:8085/api/GetMarketIdsV1?eventid=${eventid}`, {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Log the fetched market IDs
    console.log(`Fetched Market IDs V1 for Event ID ${eventid}:`, response.data);

    // Return the response directly
    res.json(response.data);
  } catch (error) {
    console.error('Market IDs V1 fetch error:', error);

    // Detailed error logging
    if (error.response) {
      console.error('Error Response Data:', error.response.data);
      console.error('Error Response Status:', error.response.status);

      // Pass through the external API's error response
      return res.status(error.response.status).json(error.response.data);
    }

    res.status(500).json({
      error: 'Error fetching market IDs V1',
      details: error.message
    });
  }
};

// Function to get Market IDs V2 (by Market ID)
const getMarketIdsV2 = async (req, res) => {
  try {
    const { market_id } = req.query;

    // Validate market ID is provided
    if (!market_id) {
      return res.status(400).json({
        error: 'Market ID is required'
      });
    }

    // Make request to external API with market ID
    const response = await axios.get(`http://89.116.20.218:8085/api/GetMarketIdsV2?market_id=${market_id}`, {
      headers: {
        'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
        'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
        'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
      }
    });

    // Log the fetched market IDs
    console.log(`Fetched Market IDs V2 for Market ID ${market_id}:`, response.data);

    // Return the response directly
    res.json(response.data);
  } catch (error) {
    console.error('Market IDs V2 fetch error:', error);

    // Detailed error logging
    if (error.response) {
      console.error('Error Response Data:', error.response.data);
      console.error('Error Response Status:', error.response.status);

      // Pass through the external API's error response
      return res.status(error.response.status).json(error.response.data);
    }

    res.status(500).json({
      error: 'Error fetching market IDs V2',
      details: error.message
    });
  }
};

module.exports = { 
  getMarketIdsV1,
  getMarketIdsV2
};