const axios = require('axios');


// Function to get market details (by Market ID)
const getMarketDetails = async (req, res) => {
    try {
      const { market_id } = req.query;
  
      // Validate market ID is provided
      if (!market_id) {
        return res.status(400).json({
          error: 'Market ID is required'
        });
      }
  
      // Make request to external API with market ID
      const response = await axios.get(`http://89.116.20.218:8085/api/GetMarketDetails?market_id=${market_id}`, {
        headers: {
          'x-rapidapi-key': process.env.RAPIDAPI_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31',
          'x-rapidapi-host': process.env.RAPIDAPI_HOST ?? 'betfair14.p.rapidapi.com',
          'X-ScoreSwift-Key': process.env.SCORESWIFT_KEY ?? 'eNp57Jb7yHgI26S8Yw4u_v31'
        }
      });
  
      // Log the fetched market IDs
      console.log(`Fetched market details for Market ID ${market_id}:`, response.data);
  
      // Return the response directly
      res.json(response.data);
    } catch (error) {
      console.error('market details fetch error:', error);
  
      // Detailed error logging
      if (error.response) {
        console.error('Error Response Data:', error.response.data);
        console.error('Error Response Status:', error.response.status);
  
        // Pass through the external API's error response
        return res.status(error.response.status).json(error.response.data);
      }
  
      res.status(500).json({
        error: 'Error fetching market details',
        details: error.message
      });
    }
  };
  
  module.exports = { 
    getMarketDetails
  };