const pg     = require('../../General/Model');
const bcrypt = require('bcrypt');
const jwt    = require('jsonwebtoken');

exports.login = async (req,res,next)=>{
  try{
    const { email,password } = req.body;
    console.log('Login attempt with email:', email);
    console.log('Login attempt with password:', password ? password : 'undefined');
    
    if(!email || !password)
      return res.status(400).json({status:'fail',message:'Email and password are required'});
    if(typeof email!=='string' || typeof password!=='string')
      return res.status(400).json({status:'fail',message:'Email and password must be strings'});
    
    // Updated query to get staff info with role
    const { rows } = await pg.query(`
      SELECT 
        s.id, 
        s.name, 
        s.email, 
        s.password, 
        s.role_id,
        r.name as role_name,
        r.level as role_level,
        r.responsibilities
      FROM staff s
      LEFT JOIN roles r ON s.role_id = r.id
      WHERE s.email = $1
    `, [email]);
    
    if(!rows.length)
      return res.status(400).json({status:'fail',message:'Bad email'});
    
    const staff = rows[0];
    
    console.log('password from DB:', staff.password);
    console.log('bcrypt compare result:', await bcrypt.compare(password, staff.password));
    
    if(!(await bcrypt.compare(password, staff.password)))
      return res.status(400).json({status:'fail',message:'Bad password'});
    
    // Create JWT token with comprehensive user data
    const tokenPayload = {
      id: staff.id,
      name: staff.name,
      email: staff.email,
      role_id: staff.role_id,
      role_name: staff.role_name,
      role_level: staff.role_level
    };
    
    const token = jwt.sign(tokenPayload, process.env.JWT_SECRET, {expiresIn:'2h'});
    

    await pg.query(`INSERT INTO tokens (uid, key) VALUES ($1, $2)`, [staff.id, token]);

    // Send response with token and user data
    res.json({
      status:'success',
      token: token,
      user: {
        id: staff.id,
        name: staff.name,
        email: staff.email,
        role: {
          id: staff.role_id,
          name: staff.role_name,
          level: staff.role_level,
          responsibilities: staff.responsibilities
        }
      }
    });
    
  }catch(e){ 
    if(e.code==='23505') return res.status(400).json({status:'fail',message:'Email already exists'});
    if(e.code==='23502') return res.status(400).json({status:'fail',message:'Email and password are required'});
    if(e.code==='23514') return res.status(400).json({status:'fail',message:'Email must be a valid email address'});
    if(e.code==='23503') return res.status(400).json({status:'fail',message:'Invalid email or password'});
    console.error(e);
    next(e);
  }
};