
const jwt = require('jsonwebtoken');
const pg  = require('../../General/Model');

exports.protectStaff = async (req, res, next) => {
  try {
    const header = req.headers.authorization || '';
    if (!header.startsWith('Bearer ')) {
      return res.status(401).json({ status: 'fail', message: 'No token' });
    }

    let decoded;
    try {
      // Extract and verify the JWT token
      decoded = jwt.verify(header.slice(7), process.env.JWT_SECRET);
    } catch (jwtError) {
      // Handle JWT-specific errors
      if (jwtError.name === 'TokenExpiredError') {
        return res.status(401).json({ 
          status: 'fail', 
          message: 'Token expired' 
        });
      } else if (jwtError.name === 'JsonWebTokenError') {
        return res.status(401).json({ 
          status: 'fail', 
          message: 'Invalid token' 
        });
      } else if (jwtError.name === 'NotBeforeError') {
        return res.status(401).json({ 
          status: 'fail', 
          message: 'Token not active' 
        });
      } else {
        return res.status(401).json({ 
          status: 'fail', 
          message: 'Token verification failed' 
        });
      }
    }

    const { id } = decoded;
    
    const { rows } = await pg.query(
      `SELECT s.id, s.role_id, r.level
       FROM staff s JOIN roles r ON r.id = s.role_id
       WHERE s.id = $1`, [id]
    );
    
    if (!rows.length) {
      return res.status(401).json({ 
        status: 'fail', 
        message: 'Staff not found' 
      });
    }
    
    req.staff = rows[0]; // {id, role_id, level}
    next();
  } catch (e) {
    next(e);
  }
};